/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.starter.common;

import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.ext.proxy.annotation.Command;
import cn.sylinx.hbatis.ext.proxy.command.CommandRegistry;
import cn.sylinx.hbatis.ext.starter.common.PluginBuilder;
import cn.sylinx.hbatis.ext.starter.common.PropertiesEnvironment;
import cn.sylinx.hbatis.io.ClasspathResourceScanner;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.IPlugin;
import cn.sylinx.hbatis.plugin.PluginStarter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;

class StarterBean {
    private String config = "/hbatis.properties";
    private Properties p;

    public StarterBean() {
        this(null);
    }

    public StarterBean(String config) {
        if (config != null && !"".equals(config)) {
            this.config = config;
        }
        this.init();
    }

    private void init() {
        this.p = new Properties();
        try {
            this.p.load(StarterBean.class.getResourceAsStream(this.config));
        }
        catch (IOException e) {
            throw new HbatisException(e);
        }
    }

    public void start() {
        String initKey = "hbatis.init";
        String initStr = this.p.getProperty(initKey, "false");
        boolean init = Boolean.valueOf(initStr);
        if (!init) {
            GLog.info("hbatis \u6ca1\u6709\u88ab\u521d\u59cb\u5316\uff0c\u8bf7\u786e\u8ba4hbatis.init=true\u3002", new Object[0]);
            return;
        }
        this.registerCommand(this.p);
        PluginStarter pluginStarter = this.create(this.p);
        pluginStarter.start();
    }

    private PluginStarter create(Properties p) {
        List<IPlugin> pluginList = new PluginBuilder(new PropertiesEnvironment(p)).initDataSourcePlugin().initModelPreLoadPlugin().initSqlResourcePreloadPlugin().initStatementHandlerPlugin().initTransactionPlugin().initCachePlugin().initDebugPlugin().initOptimisticLockPlugin().initProxyPlugin().build();
        PluginStarter pluginStarter = new PluginStarter(pluginList);
        return pluginStarter;
    }

    private void registerCommand(Properties p) {
        String commandScanPackage = Optional.ofNullable(p.getProperty("hbatis.command.scanpackage")).orElse("");
        if (StrKit.isBlank(commandScanPackage)) {
            GLog.warn("hbatis.command.scanpackage\u6ca1\u6709\u914d\u7f6e\uff0c\u8fd9\u5c06\u5bfc\u81f4\u82b1\u8d39\u66f4\u591a\u65f6\u95f4\u626b\u63cf\u6574\u4e2a\u9879\u76ee", new Object[0]);
        }
        GLog.info("\u626b\u63cf\u5305:{}, \u5bfb\u627e@Command\u5bf9\u8c61", StrKit.isBlank(commandScanPackage) ? "\u6574\u4e2a\u9879\u76ee" : commandScanPackage);
        HashSet<String> clzSets = new HashSet<String>(16);
        ClasspathResourceScanner cp = new ClasspathResourceScanner(commandScanPackage, ".class", true);
        List<String> rList = null;
        try {
            rList = cp.getResourceNameList();
        }
        catch (Exception e) {
            GLog.error("scan error", e);
        }
        if (rList == null) {
            rList = new ArrayList<String>();
        }
        for (String rs : rList) {
            if (commandScanPackage == "") {
                rs = rs.substring(1);
            }
            String pt1 = rs.replaceAll("/", "\\.");
            int index = pt1.lastIndexOf(".class");
            pt1 = pt1.substring(0, index);
            clzSets.add(pt1);
        }
        if (clzSets == null || clzSets.isEmpty()) {
            return;
        }
        for (String clzStr : clzSets) {
            try {
                Class<?> clz = Class.forName(clzStr);
                Command command = clz.getDeclaredAnnotation(Command.class);
                if (!clz.isInterface() || clz.getSuperclass() != null || command == null) continue;
                GLog.info("\u6ce8\u518cCommand\u5bf9\u8c61:{}", clz.getName());
                CommandRegistry.INSTANCE.addCommond(clz);
            }
            catch (Throwable e) {
                GLog.error("register error", e);
            }
        }
        GLog.info("\u5bfb\u627e@Command\u5bf9\u8c61\u5b8c\u6bd5\uff0c\u603b\u8ba1:{}", CommandRegistry.INSTANCE.getCommands().size());
    }
}

