/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.starter.common;

import cn.sylinx.hbatis.db.dialect.DbType;
import cn.sylinx.hbatis.ds.DataSourceWrapper;
import cn.sylinx.hbatis.ext.starter.common.CommonRelaxedPropertyResolverWrapper;
import cn.sylinx.hbatis.ext.starter.common.EnvironmentWrapper;
import cn.sylinx.hbatis.ext.starter.common.RelaxedPropertyResolverWrapper;
import cn.sylinx.hbatis.ext.starter.pool.DataSourceWrapperFactory;
import cn.sylinx.hbatis.kit.ClassUtil;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.IPlugin;
import cn.sylinx.hbatis.plugin.cache.GuavaCacheConfig;
import cn.sylinx.hbatis.plugin.cache.GuavaCachePlugin;
import cn.sylinx.hbatis.plugin.datasource.DataSourcePlugin;
import cn.sylinx.hbatis.plugin.debug.DebugPlugin;
import cn.sylinx.hbatis.plugin.model.ModelPreloadPlugin;
import cn.sylinx.hbatis.plugin.optlock.OptimisticLockPlugin;
import cn.sylinx.hbatis.plugin.proxy.ProxyPlugin;
import cn.sylinx.hbatis.plugin.sqlres.SqlResourcePreloadPlugin;
import cn.sylinx.hbatis.plugin.statement.StatementHandlerPlugin;
import cn.sylinx.hbatis.plugin.transaction.TransactionIsolationPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

class PluginBuilder {
    private List<IPlugin> pluginList = new ArrayList<IPlugin>();
    private EnvironmentWrapper env;
    private DataSource dataSource;

    public PluginBuilder(EnvironmentWrapper env) {
        this.env = env;
    }

    public PluginBuilder(EnvironmentWrapper env, DataSource dataSource) {
        this.env = env;
        this.dataSource = dataSource;
    }

    public PluginBuilder dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    private RelaxedPropertyResolverWrapper createRelaxedPropertyResolver(String prefix) {
        return new CommonRelaxedPropertyResolverWrapper(this.env, prefix);
    }

    public PluginBuilder initModelPreLoadPlugin() {
        String scanPackageList;
        RelaxedPropertyResolverWrapper propertyResolver = this.createRelaxedPropertyResolver("hbatis.plugin.modelpreload.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return this;
        }
        GLog.debug("ModelPreloadPlugin inited.", new Object[0]);
        ModelPreloadPlugin mp = new ModelPreloadPlugin();
        String acmStrategy = propertyResolver.getProperty("acmStrategy");
        if (StrKit.isNotBlank(acmStrategy)) {
            mp.setAcmStrategyClass(acmStrategy);
        }
        if (StrKit.isNotBlank(scanPackageList = propertyResolver.getProperty("scanPackageList"))) {
            GLog.debug("ModelPreloadPlugin scanPackageList:{}", scanPackageList);
            String[] pkgArray = scanPackageList.split(",");
            mp.setScanPackageList(Arrays.asList(pkgArray));
        }
        this.pluginList.add(mp);
        return this;
    }

    public PluginBuilder initSqlResourcePreloadPlugin() {
        RelaxedPropertyResolverWrapper propertyResolver = this.createRelaxedPropertyResolver("hbatis.plugin.resource.");
        String path = propertyResolver.getProperty("sqlpath");
        if (StrKit.isBlank(path)) {
            return this;
        }
        GLog.debug("SqlResourcePreloadPlugin inited.", new Object[0]);
        String[] pathArray = path.split(",");
        List<String> pathList = Arrays.asList(pathArray);
        SqlResourcePreloadPlugin plugin = new SqlResourcePreloadPlugin(pathList);
        this.pluginList.add(plugin);
        return this;
    }

    public PluginBuilder initStatementHandlerPlugin() {
        RelaxedPropertyResolverWrapper propertyResolver = this.createRelaxedPropertyResolver("hbatis.plugin.statement.");
        String statementHandlerClass = propertyResolver.getProperty("clazz");
        if (StrKit.isBlank(statementHandlerClass)) {
            return this;
        }
        GLog.debug("StatementHandlerPlugin inited.", new Object[0]);
        StatementHandlerPlugin shp = new StatementHandlerPlugin();
        shp.setStatementHandlerClass(statementHandlerClass);
        this.pluginList.add(shp);
        return this;
    }

    public PluginBuilder initTransactionPlugin() {
        RelaxedPropertyResolverWrapper propertyResolver = this.createRelaxedPropertyResolver("hbatis.plugin.transaction.");
        String level = propertyResolver.getProperty("level");
        if (StrKit.isBlank(level)) {
            return this;
        }
        GLog.debug("TransactionIsolationPlugin inited.", new Object[0]);
        int levelInt = Integer.parseInt(level);
        TransactionIsolationPlugin plugin = new TransactionIsolationPlugin(levelInt);
        this.pluginList.add(plugin);
        return this;
    }

    public PluginBuilder initDebugPlugin() {
        DebugPlugin debugPlugin = new DebugPlugin();
        String debugStr = this.env.getProperty("hbatis.debug", "false");
        boolean debug = Boolean.valueOf(debugStr);
        debugPlugin.setDebug(debug);
        this.pluginList.add(debugPlugin);
        return this;
    }

    public PluginBuilder initOptimisticLockPlugin() {
        OptimisticLockPlugin optimisticLockPlugin = new OptimisticLockPlugin();
        String optimisticLockStr = this.env.getProperty("hbatis.optimistic-lock.enable", "false");
        boolean optimisticLockEnale = Boolean.valueOf(optimisticLockStr);
        optimisticLockPlugin.setEnableOptimisticLock(optimisticLockEnale);
        this.pluginList.add(optimisticLockPlugin);
        return this;
    }

    public PluginBuilder initCachePlugin() {
        RelaxedPropertyResolverWrapper propertyResolver = this.createRelaxedPropertyResolver("hbatis.plugin.cache.");
        boolean useCache = Boolean.valueOf(propertyResolver.getProperty("inited", "false"));
        if (!useCache) {
            return this;
        }
        boolean isClassExist = ClassUtil.isClassExist("com.google.common.cache.CacheBuilder");
        if (!isClassExist) {
            GLog.error("guava\u4f9d\u8d56\u5e93\u6ca1\u6709\u52a0\u8f7d\uff0c\u7f13\u5b58\u63d2\u4ef6\u65e0\u6cd5\u521d\u59cb\u5316", new Object[0]);
            return this;
        }
        String expire = propertyResolver.getProperty("expire", "5");
        String maxSize = propertyResolver.getProperty("maxSize", "2000");
        long expireLong = 5L;
        long maxSizeLong = 2000L;
        try {
            expireLong = Long.parseLong(expire);
            maxSizeLong = Long.parseLong(maxSize);
        }
        catch (Exception e) {
            GLog.error("cache config error, use default", e);
        }
        GuavaCacheConfig gcc = new GuavaCacheConfig();
        gcc.setExpireAfterWrite(expireLong);
        gcc.setMaximumSize(maxSizeLong);
        GLog.debug("cache config, expireAfterWrite:{}, maximumSize:{}", expireLong, maxSizeLong);
        this.pluginList.add(new GuavaCachePlugin(gcc));
        return this;
    }

    public PluginBuilder initProxyPlugin() {
        String[] clzArray;
        RelaxedPropertyResolverWrapper propertyResolver = this.createRelaxedPropertyResolver("hbatis.plugin.proxy.");
        String clzList = propertyResolver.getProperty("class");
        if (StrKit.isBlank(clzList)) {
            return this;
        }
        ProxyPlugin plugin = new ProxyPlugin();
        for (String clz : clzArray = clzList.split(",")) {
            if (!StrKit.isNotBlank(clz)) continue;
            IPlugin item = null;
            try {
                item = (IPlugin)Class.forName(clz.trim()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                GLog.error("\u521d\u59cb\u5316\u63d2\u4ef6\u5931\u8d25, clz: " + clz, e);
            }
            if (item == null) continue;
            plugin.addPlugin(item);
        }
        this.pluginList.add(plugin);
        return this;
    }

    private DataSourceWrapper buildDataSource(Map<String, Object> dsMap, Map<String, Object> extConfig) {
        return DataSourceWrapperFactory.buildDataSource(dsMap, extConfig);
    }

    public PluginBuilder initDataSourcePlugin() {
        DataSourcePlugin p = new DataSourcePlugin();
        DataSourceWrapper defaultDataSource = null;
        if (this.dataSource != null) {
            String dbtype = this.env.getProperty("hbatis.ds.dbtype", DbType.MYSQL.getValue());
            defaultDataSource = DataSourceWrapper.create(this.dataSource, DbType.getDbType(dbtype));
        } else {
            RelaxedPropertyResolverWrapper propertyResolver = this.createRelaxedPropertyResolver("hbatis.datasource.default.");
            HashMap<String, Object> dsMap = new HashMap<String, Object>();
            dsMap.put("url", propertyResolver.getProperty("url"));
            dsMap.put("driver", propertyResolver.getProperty("driver"));
            dsMap.put("username", propertyResolver.getProperty("username"));
            dsMap.put("password", propertyResolver.getProperty("password"));
            dsMap.put("dbtype", propertyResolver.getProperty("dbtype"));
            dsMap.put("pooltype", propertyResolver.getProperty("pooltype"));
            Map<String, Object> extConfig = propertyResolver.getSubProperties("config.");
            defaultDataSource = this.buildDataSource(dsMap, extConfig);
        }
        p.setDataSourceWrapper(defaultDataSource);
        this.pluginList.add(p);
        RelaxedPropertyResolverWrapper propertyResolverMulti = this.createRelaxedPropertyResolver("hbatis.datasource.multi.");
        String dsPrefixs = propertyResolverMulti.getProperty("names");
        if (dsPrefixs == null || "".equals(dsPrefixs)) {
            return this;
        }
        for (String dsPrefix : dsPrefixs.split(",")) {
            Map<String, Object> dsMapMulti = propertyResolverMulti.getSubProperties(dsPrefix + ".");
            Map<String, Object> extConfigMulti = propertyResolverMulti.getSubProperties(dsPrefix + ".config.");
            DataSourceWrapper ds = this.buildDataSource(dsMapMulti, extConfigMulti);
            DataSourcePlugin ptmp = new DataSourcePlugin();
            ptmp.setJdbcResourceName(dsPrefix);
            ptmp.setDataSourceWrapper(ds);
            this.pluginList.add(ptmp);
        }
        return this;
    }

    public List<IPlugin> build() {
        return this.pluginList;
    }
}

