/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.res;

import cn.sylinx.hbatis.io.Resources;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.debug.DebugWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class ClasspathSqlResourceManager {
    private static final Map<String, String> cache = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, String> map = cache;
        synchronized (map) {
            cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String sqlpath) {
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        String statement = null;
        try {
            is = Resources.getResourceAsStream(sqlpath);
            if (is != null) {
                baos = new ByteArrayOutputStream();
                int i = -1;
                while ((i = is.read()) != -1) {
                    baos.write(i);
                }
                statement = baos.toString();
            }
        }
        catch (Exception e) {
            GLog.error("sql resource not found: {}", sqlpath);
            statement = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return statement;
    }

    public static String loadAndGet(String sqlpath) {
        String statement = ClasspathSqlResourceManager.get(sqlpath);
        if (statement != null) {
            cache.put(sqlpath, statement);
        }
        return statement;
    }

    public static String getStatement(String sqlpath) {
        if (DebugWrapper.ME.isDebug()) {
            return ClasspathSqlResourceManager.get(sqlpath);
        }
        if (cache.containsKey(sqlpath)) {
            GLog.debug("sql bingo: {}", sqlpath);
            return cache.get(sqlpath);
        }
        return ClasspathSqlResourceManager.loadAndGet(sqlpath);
    }
}

