/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.proxy.command;

import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.ext.proxy.command.CommandProxy;
import cn.sylinx.hbatis.ext.proxy.command.CommandProxyFactory;
import cn.sylinx.hbatis.kit.ClassUtil;
import cn.sylinx.hbatis.log.GLog;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum CommandRegistry {
    INSTANCE;

    private final Map<Class<?>, CommandProxyFactory<?>> knownCommands = new HashMap();

    public <T> boolean hasCommand(Class<T> type) {
        return this.knownCommands.containsKey(type);
    }

    public <T> void addCommond(Class<T> type) {
        if (type.isInterface()) {
            if (this.hasCommand(type)) {
                throw new HbatisException("Type " + type + " is already known to the CommandRegistry.");
            }
            this.knownCommands.put(type, new CommandProxyFactory<T>(type));
            GLog.debug("hbatis command: {} registry ok", type.getName());
        }
    }

    public <T> void addCommond(String className) {
        Class<?> type = null;
        ClassLoader clToUse = ClassUtil.getDefaultClassLoader();
        try {
            type = Class.forName(className, false, clToUse);
        }
        catch (Exception e) {
            GLog.error("no class defined", e);
        }
        if (type == null) {
            return;
        }
        this.addCommond(type);
    }

    public <T> T getCommand(Class<T> type) {
        CommandProxyFactory<?> commandProxyFactory = this.knownCommands.get(type);
        if (commandProxyFactory == null) {
            throw new HbatisException("Type " + type + " is not known to the CommandRegistry.");
        }
        try {
            return (T)commandProxyFactory.newInstance(new CommandProxy<T>(type));
        }
        catch (Exception e) {
            throw new HbatisException("Error getting command instance. Cause: " + e, e);
        }
    }

    public Collection<Class<?>> getCommands() {
        return Collections.unmodifiableCollection(this.knownCommands.keySet());
    }
}

