/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.proxy.command;

import cn.sylinx.hbatis.db.common.Page;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.ext.proxy.annotation.Resource;
import cn.sylinx.hbatis.ext.proxy.annotation.ResourceType;
import cn.sylinx.hbatis.ext.proxy.command.MethodMetadata;
import cn.sylinx.hbatis.ext.proxy.invoker.BeanListCommandInvoker;
import cn.sylinx.hbatis.ext.proxy.invoker.BeanPageCommandInvoker;
import cn.sylinx.hbatis.ext.proxy.invoker.BeanQueryOneCommandInvoker;
import cn.sylinx.hbatis.ext.proxy.invoker.CommandInvoker;
import cn.sylinx.hbatis.ext.proxy.invoker.ExecuteCommandInvoker;
import cn.sylinx.hbatis.ext.proxy.invoker.ObjectListCommandInvoker;
import cn.sylinx.hbatis.ext.proxy.invoker.ObjectQueryOneCommandInvoker;
import cn.sylinx.hbatis.ext.proxy.invoker.RecordListCommandInvoker;
import cn.sylinx.hbatis.ext.proxy.invoker.RecordPageCommandInvoker;
import cn.sylinx.hbatis.ext.proxy.invoker.RecordQueryOneCommandInvoker;
import cn.sylinx.hbatis.ext.proxy.invoker.UpdateCommandInvoker;
import cn.sylinx.hbatis.kit.Tuple;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CommandInvokeHandler
implements CommandInvoker {
    private static Set<Class<?>> primaryOrMappedWrapTypeOrFrequentType = new HashSet(8);
    private MethodMetadata metadata;
    private Tuple tuple;

    CommandInvokeHandler(MethodMetadata metadata, Tuple tuple) {
        this.metadata = metadata;
        this.tuple = tuple;
    }

    private boolean isRecordForTruelyReturnType(Class<?> truelyReturnType) {
        return truelyReturnType == Record.class;
    }

    private boolean isPrimaryOrMappedWrapTypeOrFrequentType(Class<?> truelyReturnType) {
        return primaryOrMappedWrapTypeOrFrequentType.contains(truelyReturnType);
    }

    private CommandInvoker getCommandInvoker() {
        ArrayList<Creator> creatorList = new ArrayList<Creator>();
        creatorList.add(new UpdateCommandInvokerCreator());
        creatorList.add(new ExecuteCommandInvokerCreator());
        creatorList.add(new RecordListCommandInvokerCreator());
        creatorList.add(new ObjectListCommandInvokerCreator());
        creatorList.add(new BeanListCommandInvokerCreator());
        creatorList.add(new RecordPageCommandInvokerCreator());
        creatorList.add(new BeanPageCommandInvokerCreator());
        creatorList.add(new ObjectQueryOneCommandInvokerCreator());
        creatorList.add(new RecordQueryOneCommandInvokerCreator());
        creatorList.add(new BeanQueryOneCommandInvokerCreator());
        for (Creator creator : creatorList) {
            CommandInvoker commandInvoker = creator.create();
            if (commandInvoker == null) continue;
            return commandInvoker;
        }
        throw new HbatisException("no suitable command invoker");
    }

    @Override
    public Object invoke() {
        CommandInvoker invoker = this.getCommandInvoker();
        try {
            Object object = invoker.invoke();
            return object;
        }
        finally {
            invoker.releaseResource();
            invoker = null;
        }
    }

    @Override
    public void releaseResource() {
        this.tuple = null;
        this.metadata = null;
    }

    static {
        primaryOrMappedWrapTypeOrFrequentType.add(Boolean.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Boolean.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Byte.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Byte.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Character.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Character.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Short.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Short.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Integer.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Integer.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Long.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Long.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Float.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Float.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Double.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Double.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(String.class);
        primaryOrMappedWrapTypeOrFrequentType.add(BigInteger.class);
        primaryOrMappedWrapTypeOrFrequentType.add(BigDecimal.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Date.class);
    }

    private class BeanQueryOneCommandInvokerCreator
    implements Creator {
        private BeanQueryOneCommandInvokerCreator() {
        }

        @Override
        public CommandInvoker create() {
            Map params = (Map)CommandInvokeHandler.this.tuple.getObject(0);
            String truelyDatasource = (String)CommandInvokeHandler.this.tuple.getObject(3);
            Resource resource = CommandInvokeHandler.this.metadata.getResource();
            Class<?> returnType = CommandInvokeHandler.this.metadata.getReturnType();
            if (!CommandInvokeHandler.this.isPrimaryOrMappedWrapTypeOrFrequentType(returnType) && !CommandInvokeHandler.this.isRecordForTruelyReturnType(returnType)) {
                return new BeanQueryOneCommandInvoker(truelyDatasource, resource.sql(), params, returnType, resource.nativeSql(), resource.useCache());
            }
            return null;
        }
    }

    private class RecordQueryOneCommandInvokerCreator
    implements Creator {
        private RecordQueryOneCommandInvokerCreator() {
        }

        @Override
        public CommandInvoker create() {
            Map params = (Map)CommandInvokeHandler.this.tuple.getObject(0);
            String truelyDatasource = (String)CommandInvokeHandler.this.tuple.getObject(3);
            Resource resource = CommandInvokeHandler.this.metadata.getResource();
            Class<?> returnType = CommandInvokeHandler.this.metadata.getReturnType();
            if (CommandInvokeHandler.this.isRecordForTruelyReturnType(returnType)) {
                return new RecordQueryOneCommandInvoker(truelyDatasource, resource.sql(), params, returnType, resource.nativeSql(), resource.useCache());
            }
            return null;
        }
    }

    private class ObjectQueryOneCommandInvokerCreator
    implements Creator {
        private ObjectQueryOneCommandInvokerCreator() {
        }

        @Override
        public CommandInvoker create() {
            Map params = (Map)CommandInvokeHandler.this.tuple.getObject(0);
            String truelyDatasource = (String)CommandInvokeHandler.this.tuple.getObject(3);
            Resource resource = CommandInvokeHandler.this.metadata.getResource();
            Class<?> returnType = CommandInvokeHandler.this.metadata.getReturnType();
            if (CommandInvokeHandler.this.isPrimaryOrMappedWrapTypeOrFrequentType(returnType)) {
                return new ObjectQueryOneCommandInvoker(truelyDatasource, resource.sql(), params, returnType, resource.nativeSql(), resource.useCache());
            }
            return null;
        }
    }

    private class BeanPageCommandInvokerCreator
    implements Creator {
        private BeanPageCommandInvokerCreator() {
        }

        @Override
        public CommandInvoker create() {
            Map params = (Map)CommandInvokeHandler.this.tuple.getObject(0);
            String truelyDatasource = (String)CommandInvokeHandler.this.tuple.getObject(3);
            Resource resource = CommandInvokeHandler.this.metadata.getResource();
            Class<?> truelyReturnType = CommandInvokeHandler.this.metadata.getTruelyReturnType();
            Class<?> returnType = CommandInvokeHandler.this.metadata.getReturnType();
            int pageNumber = (Integer)CommandInvokeHandler.this.tuple.getObject(1);
            int pageSize = (Integer)CommandInvokeHandler.this.tuple.getObject(2);
            if (returnType == Page.class && !CommandInvokeHandler.this.isRecordForTruelyReturnType(truelyReturnType)) {
                return new BeanPageCommandInvoker(truelyDatasource, resource.sql(), params, pageNumber, pageSize, truelyReturnType, resource.nativeSql());
            }
            return null;
        }
    }

    private class RecordPageCommandInvokerCreator
    implements Creator {
        private RecordPageCommandInvokerCreator() {
        }

        @Override
        public CommandInvoker create() {
            Map params = (Map)CommandInvokeHandler.this.tuple.getObject(0);
            String truelyDatasource = (String)CommandInvokeHandler.this.tuple.getObject(3);
            Resource resource = CommandInvokeHandler.this.metadata.getResource();
            Class<?> truelyReturnType = CommandInvokeHandler.this.metadata.getTruelyReturnType();
            Class<?> returnType = CommandInvokeHandler.this.metadata.getReturnType();
            int pageNumber = (Integer)CommandInvokeHandler.this.tuple.getObject(1);
            int pageSize = (Integer)CommandInvokeHandler.this.tuple.getObject(2);
            if (returnType == Page.class && CommandInvokeHandler.this.isRecordForTruelyReturnType(truelyReturnType)) {
                return new RecordPageCommandInvoker(truelyDatasource, resource.sql(), params, pageNumber, pageSize, truelyReturnType, resource.nativeSql());
            }
            return null;
        }
    }

    private class BeanListCommandInvokerCreator
    implements Creator {
        private BeanListCommandInvokerCreator() {
        }

        @Override
        public CommandInvoker create() {
            Map params = (Map)CommandInvokeHandler.this.tuple.getObject(0);
            String truelyDatasource = (String)CommandInvokeHandler.this.tuple.getObject(3);
            Resource resource = CommandInvokeHandler.this.metadata.getResource();
            Class<?> truelyReturnType = CommandInvokeHandler.this.metadata.getTruelyReturnType();
            Class<?> returnType = CommandInvokeHandler.this.metadata.getReturnType();
            if (returnType == List.class && !CommandInvokeHandler.this.isPrimaryOrMappedWrapTypeOrFrequentType(truelyReturnType) && !CommandInvokeHandler.this.isRecordForTruelyReturnType(truelyReturnType)) {
                return new BeanListCommandInvoker(truelyDatasource, resource.sql(), params, truelyReturnType, resource.nativeSql(), resource.useCache());
            }
            return null;
        }
    }

    private class ObjectListCommandInvokerCreator
    implements Creator {
        private ObjectListCommandInvokerCreator() {
        }

        @Override
        public CommandInvoker create() {
            Map params = (Map)CommandInvokeHandler.this.tuple.getObject(0);
            String truelyDatasource = (String)CommandInvokeHandler.this.tuple.getObject(3);
            Resource resource = CommandInvokeHandler.this.metadata.getResource();
            Class<?> truelyReturnType = CommandInvokeHandler.this.metadata.getTruelyReturnType();
            Class<?> returnType = CommandInvokeHandler.this.metadata.getReturnType();
            if (returnType == List.class && CommandInvokeHandler.this.isPrimaryOrMappedWrapTypeOrFrequentType(truelyReturnType)) {
                return new ObjectListCommandInvoker(truelyDatasource, resource.sql(), params, truelyReturnType, resource.nativeSql(), resource.useCache());
            }
            return null;
        }
    }

    private class RecordListCommandInvokerCreator
    implements Creator {
        private RecordListCommandInvokerCreator() {
        }

        @Override
        public CommandInvoker create() {
            Map params = (Map)CommandInvokeHandler.this.tuple.getObject(0);
            String truelyDatasource = (String)CommandInvokeHandler.this.tuple.getObject(3);
            Resource resource = CommandInvokeHandler.this.metadata.getResource();
            Class<?> truelyReturnType = CommandInvokeHandler.this.metadata.getTruelyReturnType();
            Class<?> returnType = CommandInvokeHandler.this.metadata.getReturnType();
            if (returnType == List.class && CommandInvokeHandler.this.isRecordForTruelyReturnType(truelyReturnType)) {
                return new RecordListCommandInvoker(truelyDatasource, resource.sql(), params, truelyReturnType, resource.nativeSql(), resource.useCache());
            }
            return null;
        }
    }

    private class ExecuteCommandInvokerCreator
    implements Creator {
        private ExecuteCommandInvokerCreator() {
        }

        @Override
        public CommandInvoker create() {
            boolean isExecute;
            Map params = (Map)CommandInvokeHandler.this.tuple.getObject(0);
            String truelyDatasource = (String)CommandInvokeHandler.this.tuple.getObject(3);
            Resource resource = CommandInvokeHandler.this.metadata.getResource();
            boolean bl = isExecute = resource.resourceType() == ResourceType.EXECUTE;
            if (isExecute) {
                return new ExecuteCommandInvoker(truelyDatasource, resource.sql(), params, resource.nativeSql());
            }
            return null;
        }
    }

    private class UpdateCommandInvokerCreator
    implements Creator {
        private UpdateCommandInvokerCreator() {
        }

        @Override
        public CommandInvoker create() {
            boolean isUpdate;
            Map params = (Map)CommandInvokeHandler.this.tuple.getObject(0);
            String truelyDatasource = (String)CommandInvokeHandler.this.tuple.getObject(3);
            Resource resource = CommandInvokeHandler.this.metadata.getResource();
            boolean bl = isUpdate = resource.resourceType() == ResourceType.UPDATE;
            if (isUpdate) {
                return new UpdateCommandInvoker(truelyDatasource, resource.sql(), params, resource.nativeSql());
            }
            return null;
        }
    }

    private static interface Creator {
        public CommandInvoker create();
    }
}

