/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.parse;

import cn.sylinx.hbatis.ext.parse.TokenHandler;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import java.util.Collection;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;

public class SqlTokenHandler
implements TokenHandler {
    private static final String NOT_NULL_FLAG = "!!";
    private Map<String, Object> params;

    @Override
    public void setParameterMap(Map<String, Object> parameterMap) {
        this.params = parameterMap;
    }

    @Override
    public Object handle(String content) {
        return StrKit.isNotBlank(content) ? (this.params == null ? null : this.params.get(content)) : null;
    }

    @Override
    public boolean condition(String condition) {
        if (this.params == null) {
            return false;
        }
        if (condition == null) {
            return false;
        }
        if ((condition = condition.trim()).startsWith(NOT_NULL_FLAG)) {
            String trueField = condition.substring(NOT_NULL_FLAG.length()).trim();
            if ("".equals(trueField)) {
                return false;
            }
            Object value = this.params.get(trueField);
            if (value == null) {
                return false;
            }
            if (value instanceof String) {
                return !"".equals(value.toString());
            }
            if (value instanceof Collection) {
                return !((Collection)value).isEmpty();
            }
            return true;
        }
        try {
            Object ret = Ognl.getValue((String)condition, this.params);
            if (ret instanceof Boolean) {
                return (Boolean)ret;
            }
        }
        catch (OgnlException e) {
            GLog.error("Ognl getValue error, exp:" + condition, e);
            return false;
        }
        return false;
    }
}

