/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.parse;

import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.ext.function.FunctionParser;
import cn.sylinx.hbatis.ext.ifblock.IfEndBlockParserImpl;
import cn.sylinx.hbatis.ext.ifblock.IfEndMatcherImpl;
import cn.sylinx.hbatis.ext.parse.TokenHandler;
import cn.sylinx.hbatis.kit.Tuple;
import cn.sylinx.hbatis.log.GLog;
import java.util.ArrayList;
import java.util.List;

public class GenericTokenParser {
    private static final String TOKEN_BEGIN = "#{";
    private static final String TOKEN_END = "}";
    private static final String TOKEN_DY_BEGIN = "${";
    private static final String TOKEN_DY_END = "}";
    private static final String TOKEN_IF_BEGIN = "#IF";
    private TokenHandler handler;

    public GenericTokenParser(TokenHandler handler) {
        this.handler = handler;
    }

    protected String formatPreStatement(String preSt) {
        return preSt.replaceAll("\r", " ").replaceAll("\n", " ").replaceAll("\t", " ");
    }

    public Tuple parse(String preSt, boolean format) {
        String preSt1 = format ? this.formatPreStatement(preSt) : preSt;
        String preSt2 = this.parseIfDynamicSql(preSt1);
        String preSt3 = this.parseDynamicPartSql(preSt2);
        String st = this.parseFunctions(preSt3);
        return this.parseSqlAndParameters(st);
    }

    private Tuple parseSqlAndParameters(String st) {
        ArrayList<Object> ps = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        this.getNextPart(st, sb, ps);
        String rst = sb.toString();
        sb.setLength(0);
        Object[] params = new Object[ps.size()];
        ps.toArray(params);
        GLog.debug("origin sql: " + rst, new Object[0]);
        GLog.debug("origin parameters:" + ps, new Object[0]);
        return Tuple.apply(rst, params);
    }

    public Tuple parse(String preSt) {
        return this.parse(preSt, true);
    }

    protected String parseFunctions(String st) {
        return new FunctionParser(this.handler).parse(st);
    }

    protected String parseIfDynamicSql(String st) {
        StringBuilder sb = new StringBuilder();
        this.parseDynamicSqlNext(st, sb);
        return sb.toString();
    }

    protected String parseDynamicPartSql(String st) {
        StringBuilder sb = new StringBuilder();
        this.parseDynamicPartSqlNext(st, sb);
        return sb.toString();
    }

    private void parseDynamicPartSqlNext(String st, StringBuilder sb) {
        if (st == null) {
            throw new HbatisException("statment is null");
        }
        int is = st.indexOf(TOKEN_DY_BEGIN);
        if (is == -1) {
            sb.append(st);
            return;
        }
        String tmp = st.substring(is);
        int is1 = tmp.indexOf("}");
        int ie = is1 + is;
        if (is1 == -1) {
            throw new HbatisException("illegal statement");
        }
        String split = st.substring(is + TOKEN_DY_BEGIN.length(), ie);
        String dynamicSql = null;
        Object dynamicObject = this.handler.handle(split);
        if (dynamicObject != null) {
            dynamicSql = dynamicObject.toString();
        }
        String before = st.substring(0, is) + (dynamicSql == null ? "" : dynamicSql);
        sb.append(before);
        String after = st.substring(ie + "}".length());
        this.parseDynamicPartSqlNext(after, sb);
    }

    private void parseDynamicSqlNext(String st, StringBuilder sb) {
        if (st == null) {
            throw new HbatisException("statment is null");
        }
        int is = st.indexOf(TOKEN_IF_BEGIN);
        if (is == -1) {
            sb.append(st.trim()).append(" ");
            return;
        }
        String left = st.substring(is);
        String split = this.findMatchIfEnd(left);
        int ie = is + split.length();
        boolean bl = split.startsWith("#IF[");
        if (!bl) {
            throw new HbatisException("illegal condition statement");
        }
        String before = st.substring(0, is);
        sb.append(before.trim()).append(" ");
        IfEndBlockParserImpl block = new IfEndBlockParserImpl(this.handler);
        sb.append(block.parse(split));
        String after = st.substring(ie);
        this.parseDynamicSqlNext(after, sb);
    }

    private String findMatchIfEnd(String left) {
        IfEndMatcherImpl matcher = new IfEndMatcherImpl();
        return matcher.findMatchIfEnd(left);
    }

    private void getNextPart(String st, StringBuilder sb, List<Object> ps) {
        if (st == null) {
            throw new HbatisException("statment is null");
        }
        int is = st.indexOf(TOKEN_BEGIN);
        if (is == -1) {
            sb.append(st);
            return;
        }
        String tmp = st.substring(is);
        int is1 = tmp.indexOf("}");
        int ie = is1 + is;
        if (is1 == -1) {
            throw new HbatisException("illegal statement");
        }
        String split = st.substring(is + TOKEN_BEGIN.length(), ie);
        ps.add(this.handler.handle(split));
        String before = st.substring(0, is) + "?";
        sb.append(before);
        String after = st.substring(ie + "}".length());
        this.getNextPart(after, sb, ps);
    }
}

