/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.common.repository;

import cn.sylinx.hbatis.db.common.Callable;
import cn.sylinx.hbatis.db.common.ITransaction;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.dialect.Dialect;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.ext.common.repository.CommonRepository;
import cn.sylinx.hbatis.ext.common.spi.HbatisServiceManager;
import cn.sylinx.hbatis.ext.model.BaseModel;
import cn.sylinx.hbatis.ext.parse.SqlParser;
import cn.sylinx.hbatis.ext.res.ClasspathSqlResource;
import cn.sylinx.hbatis.kit.Ret;
import cn.sylinx.hbatis.kit.Tuple;
import cn.sylinx.hbatis.log.GLog;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

class CommonRepositoryImpl
implements CommonRepository {
    private String datasourceName;

    public CommonRepositoryImpl() {
    }

    public CommonRepositoryImpl(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    @Override
    public String getDatabase() {
        if (this.datasourceName == null) {
            this.initDatabaseInner();
        }
        return this.datasourceName;
    }

    @Override
    public Dialect getDialect() {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).getDialect();
    }

    private synchronized void initDatabaseInner() {
        if (this.datasourceName == null) {
            this.datasourceName = HbatisServiceManager.getHbatisService().getDatasourceName();
        }
    }

    @Override
    public <T> T call(Callable<T> callable) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).call(callable);
    }

    @Override
    public boolean existTable(String schema, String table) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).existTable(schema, table);
    }

    @Override
    public boolean existTableColumn(String schema, String table, String column) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).existTableColumn(schema, table, column);
    }

    @Override
    public List<Record> queryRecordsWithCache(String sql, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().queryRecords(sql, params);
    }

    @Override
    public List<Record> queryRecordsWithCache(String sql) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().queryRecords(sql, new Object[0]);
    }

    @Override
    public Record queryRecordWithCache(String sql, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().queryFirstRecord(sql, params);
    }

    @Override
    public Record queryRecordWithCache(String sql) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().queryFirstRecord(sql, new Object[0]);
    }

    @Override
    public boolean transaction(ITransaction transactions) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).transaction(transactions);
    }

    @Override
    public Ret transactionWithReturn(ITransaction transactions) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).transactionWithReturn(transactions);
    }

    @Override
    public <T> List<T> queryObject(String sql, Class<T> clazz, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryObject(sql, clazz, params);
    }

    @Override
    public <T> T queryFirstObject(String sql, Class<T> clazz, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryFirstObject(sql, clazz, params);
    }

    @Override
    public int update(String nativeSql, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).update(nativeSql, params);
    }

    @Override
    public List<Record> queryRecords(String sql, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryRecords(sql, params);
    }

    @Override
    public List<Record> queryRecords(String sql) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryRecords(sql, new Object[0]);
    }

    @Override
    public Record queryRecord(String sql, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryFirstRecord(sql, params);
    }

    @Override
    public Record queryRecord(String sql) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryFirstRecord(sql, new Object[0]);
    }

    @Override
    public <T> List<T> queryListWithCache(Class<T> clz) {
        String table = ModelBuilder.getModelTable(clz);
        if (table == null || "".equals(table.trim())) {
            throw new HbatisException("Table\u6ce8\u89e3\u8bbe\u7f6e\u503c\u4e0d\u6b63\u786e");
        }
        String sql = "select * from " + table;
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().query(sql, mapper, new Object[0]);
    }

    @Override
    public <T> List<T> queryListWithCache(String nativeSql, Class<T> clz, Object ... params) {
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().query(nativeSql, mapper, params);
    }

    @Override
    public <T> T queryFirstWithCache(String nativeSql, Class<T> clz, Object ... params) {
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().queryFirst(nativeSql, mapper, params);
    }

    @Override
    public <T> List<T> queryList(Class<T> clz) {
        String table = ModelBuilder.getModelTable(clz);
        if (table == null || "".equals(table.trim())) {
            throw new HbatisException("Table\u6ce8\u89e3\u8bbe\u7f6e\u503c\u4e0d\u6b63\u786e");
        }
        String sql = "select * from " + table;
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).query(sql, mapper, new Object[0]);
    }

    @Override
    public <T> List<T> queryList(String nativeSql, Class<T> clz, Object ... params) {
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).query(nativeSql, mapper, params);
    }

    @Override
    public <T extends BaseModel> int update(T t) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).update(t);
    }

    @Override
    public <T extends BaseModel> int delete(T t) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).delete(t);
    }

    @Override
    public <T extends BaseModel> int delete(BigInteger id, Class<T> clz) {
        String table = ModelBuilder.getModelTable(clz);
        if (table == null || "".equals(table.trim())) {
            throw new HbatisException("Table\u6ce8\u89e3\u8bbe\u7f6e\u503c\u4e0d\u6b63\u786e");
        }
        String sql = "delete from " + table + " where id = ?";
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).update(sql, id);
    }

    @Override
    public <T extends BaseModel> T save(T t) {
        if (t == null) {
            throw new HbatisException("object t is null");
        }
        Serializable pk = HbatisServiceManager.getHbatisService().use(this.getDatabase()).save(t);
        if (pk != null && t.getId() == null) {
            t.setId((Serializable)((Object)pk.toString()));
        }
        return t;
    }

    @Override
    public Serializable insert(String insertSql, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).save(insertSql, params);
    }

    @Override
    public <T extends BaseModel> boolean saveNoPk(T t) {
        if (t == null) {
            throw new HbatisException("object t is null");
        }
        try {
            HbatisServiceManager.getHbatisService().use(this.getDatabase()).save(t);
        }
        catch (Exception e) {
            GLog.error("save error", e);
            return false;
        }
        return true;
    }

    @Override
    public <T> Ret save(T t) {
        if (t == null) {
            return Ret.error("object t is null");
        }
        try {
            HbatisServiceManager.getHbatisService().use(this.getDatabase()).save(t);
        }
        catch (Exception e) {
            GLog.error("save error", e);
            return Ret.error("\u4fdd\u5b58\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
        }
        return Ret.success();
    }

    @Override
    public <T> boolean saveObjectNoPk(T t) {
        if (t == null) {
            throw new HbatisException("object t is null");
        }
        try {
            HbatisServiceManager.getHbatisService().use(this.getDatabase()).save(t);
        }
        catch (Exception e) {
            GLog.error("SaveObjectNoPk error", e);
            return false;
        }
        return true;
    }

    @Override
    public <T> Serializable saveObject(T t) {
        if (t == null) {
            throw new HbatisException("object t is null");
        }
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).save(t);
    }

    @Override
    public boolean executeLargeUpdate(List<String> exeSqlList) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).executeLargeUpdate(exeSqlList);
    }

    @Override
    public int[] batch(List<String> sql) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).batch(sql);
    }

    @Override
    public int[] batch(String sql, Object[][] params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).batch(sql, params);
    }

    @Override
    public int[] batch(String sql, Object[][] params, int batchSize) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).batch(sql, params, batchSize);
    }

    @Override
    public int[] batch(List<String> sqlList, int batchSize) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).batch(sqlList, batchSize);
    }

    @Override
    public int insert(ClasspathSqlResource resource, Map<String, Object> params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).update(resource, params);
    }

    @Override
    public int insert(ClasspathSqlResource resource) {
        return this.insert(resource, null);
    }

    @Override
    public Record queryRecord(ClasspathSqlResource resource, Map<String, Object> params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryFirstRecord(resource, params);
    }

    @Override
    public Record queryRecord(ClasspathSqlResource resource) {
        return this.queryRecord(resource, null);
    }

    @Override
    public List<Record> queryRecords(ClasspathSqlResource resource, Map<String, Object> params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryForRecords(resource, params);
    }

    @Override
    public List<Record> queryRecords(ClasspathSqlResource resource) {
        return this.queryRecords(resource, null);
    }

    @Override
    public int update(ClasspathSqlResource resource, Map<String, Object> params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).update(resource, params);
    }

    @Override
    public Object updateWithReturnPk(ClasspathSqlResource resource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(resource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).updateWithReturnPk(st, pms);
    }

    @Override
    public int update(ClasspathSqlResource resource) {
        return this.update(resource, null);
    }

    @Override
    public int delete(ClasspathSqlResource resource, Map<String, Object> params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).delete(resource, params);
    }

    @Override
    public int delete(ClasspathSqlResource resource) {
        return this.delete(resource, null);
    }

    @Override
    public Record queryRecordWithCache(ClasspathSqlResource resource, Map<String, Object> params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().queryFirstRecord(resource, params);
    }

    @Override
    public Record queryRecordWithCache(ClasspathSqlResource resource) {
        return this.queryRecordWithCache(resource, null);
    }

    @Override
    public List<Record> queryRecordsWithCache(ClasspathSqlResource resource, Map<String, Object> params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().queryForRecords(resource, params);
    }

    @Override
    public List<Record> queryRecordsWithCache(ClasspathSqlResource resource) {
        return this.queryRecordsWithCache(resource, null);
    }

    @Override
    public boolean execute(ClasspathSqlResource resource, Map<String, Object> params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).execute(resource, params);
    }

    @Override
    public boolean execute(ClasspathSqlResource resource) {
        return this.execute(resource, null);
    }

    @Override
    public <T> List<T> queryList(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).query(resource, params, clz);
    }

    @Override
    public <T> List<T> queryObjectList(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryObjectList(resource, params, clz);
    }

    @Override
    public <T> T queryFirstObject(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryFirstObject(resource, params, clz);
    }

    @Override
    public <T> List<T> queryList(ClasspathSqlResource resource, Class<T> clz) {
        return this.queryList(resource, null, clz);
    }

    @Override
    public <T> T queryFirst(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryFirst(resource, params, clz);
    }

    @Override
    public <T> T queryFirst(ClasspathSqlResource resource, Class<T> clz) {
        return this.queryFirst(resource, null, clz);
    }

    @Override
    public <T> List<T> queryListWithCache(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().query(resource, params, clz);
    }

    @Override
    public <T> List<T> queryListWithCache(ClasspathSqlResource resource, Class<T> clz) {
        return this.queryListWithCache(resource, null, clz);
    }

    @Override
    public <T> T queryFirstWithCache(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().queryFirst(resource, params, clz);
    }

    @Override
    public <T> T queryFirstWithCache(ClasspathSqlResource resource, Class<T> clz) {
        return this.queryFirstWithCache(resource, null, clz);
    }

    @Override
    public <T> List<T> queryObjectListWithCache(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> clz) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().queryObjectList(sqlResource, params, clz);
    }
}

