/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.mapper;

import cn.sylinx.hbatis.db.mapper.DeleteMapper;
import cn.sylinx.hbatis.db.mapper.InsertMapper;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.db.mapper.UpdateMapper;
import cn.sylinx.hbatis.db.mapper.anno.ColumnDesc;
import cn.sylinx.hbatis.db.mapper.anno.PrimaryKey;
import cn.sylinx.hbatis.db.mapper.anno.Table;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.plugin.model.ModelCacheManager;
import cn.sylinx.hbatis.plugin.model.ModelFabric;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelBuilder {
    public static <T> InsertMapper<T> buildInsertMapper(T t) {
        Class<?> clz = t.getClass();
        final ModelFabric mf = ModelBuilder.getModelFabric(clz);
        final String table = mf.getTableName();
        if (StrKit.isBlank(table)) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u4e3a\u7a7a");
        }
        InsertMapper mapper = new InsertMapper<T>(){

            @Override
            public String getTableName() {
                return table;
            }

            @Override
            public Map<String, String> getJavaToJdbcMapper() {
                return mf.getAttrMapping();
            }
        };
        return mapper;
    }

    public static <T> UpdateMapper<T> buildUpdateMapper(T t) {
        Class<?> clz = t.getClass();
        final ModelFabric mf = ModelBuilder.getModelFabric(clz);
        final String table = mf.getTableName();
        if (StrKit.isBlank(table)) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u4e3a\u7a7a");
        }
        final PrimaryKey pks = mf.getPrimaryKey();
        UpdateMapper mapper = new UpdateMapper<T>(){

            @Override
            public String getTableName() {
                return table;
            }

            @Override
            public Map<String, String> getJavaToJdbcMapper() {
                return mf.getAttrMapping();
            }

            @Override
            public List<String> getPrimaryKeyFieldNameList() {
                ArrayList<String> pklist = new ArrayList<String>();
                if (pks != null) {
                    String[] pkArray;
                    for (String pk : pkArray = pks.value()) {
                        if (!StrKit.isNotBlank(pk)) continue;
                        pklist.add(pk);
                    }
                }
                if (pklist.isEmpty()) {
                    pklist.add("id");
                }
                return pklist;
            }
        };
        return mapper;
    }

    public static <T> DeleteMapper<T> buildDeleteMapper(T t) {
        Class<?> clz = t.getClass();
        final ModelFabric mf = ModelBuilder.getModelFabric(clz);
        final String table = mf.getTableName();
        if (StrKit.isBlank(table)) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u4e3a\u7a7a");
        }
        final PrimaryKey pks = mf.getPrimaryKey();
        DeleteMapper mapper = new DeleteMapper<T>(){

            @Override
            public String getTableName() {
                return table;
            }

            @Override
            public Map<String, String> getJavaToJdbcMapper() {
                return mf.getAttrMapping();
            }

            @Override
            public List<String> getPrimaryKeyFieldNameList() {
                ArrayList<String> pklist = new ArrayList<String>();
                if (pks != null) {
                    String[] pkArray;
                    for (String pk : pkArray = pks.value()) {
                        if (!StrKit.isNotBlank(pk)) continue;
                        pklist.add(pk);
                    }
                }
                if (pklist.isEmpty()) {
                    pklist.add("id");
                }
                return pklist;
            }
        };
        return mapper;
    }

    public static <T> QueryMapper<T> buildQueryMapper(final Class<T> clz) {
        final ModelFabric mf = ModelBuilder.getModelFabric(clz);
        if (mf.isMappingEmpty()) {
            return null;
        }
        QueryMapper t = new QueryMapper<T>(){

            @Override
            public Map<String, String> getJdbcToJavaMapper() {
                return mf.getJdbcMapping();
            }

            @Override
            public Class<T> getValueObjectClass() {
                return clz;
            }
        };
        return t;
    }

    public static final void buildColumnNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types) throws SQLException {
        for (int i = 1; i < labelNames.length; ++i) {
            labelNames[i] = rsmd.getColumnLabel(i);
            types[i] = rsmd.getColumnType(i);
        }
    }

    public static List<Field> getObjectAllFieldsWithcache(Class<?> cclz) {
        return ModelBuilder.getModelFabric(cclz).getFields();
    }

    public static Field getVersionField(Class<?> cclz) {
        return ModelBuilder.getModelFabric(cclz).getVersionField();
    }

    public static Map<String, Field> getObjectAllFieldsMapWithcache(Class<?> cclz) {
        return ModelBuilder.getModelFabric(cclz).getFieldMap();
    }

    private static boolean isIgnoreField(Field f) {
        String modifiers = Modifier.toString(f.getModifiers());
        if (modifiers.contains("final") || modifiers.contains("static") || modifiers.contains("transient") || f.getName().equals("context")) {
            return true;
        }
        ColumnDesc cd = f.getAnnotation(ColumnDesc.class);
        return cd != null && cd.ignore();
    }

    public static List<Field> getObjectAllFields(Class<?> cclz) {
        List<Field> fds1;
        Class<?> pclz;
        ArrayList<Field> fields = new ArrayList<Field>();
        Field[] fs = cclz.getDeclaredFields();
        if (fs != null && fs.length > 0) {
            for (Field f : fs) {
                if (ModelBuilder.isIgnoreField(f)) continue;
                fields.add(f);
            }
        }
        if ((pclz = cclz.getSuperclass()) != null && !pclz.isInterface() && (fds1 = ModelBuilder.getObjectAllFields(pclz)) != null && !fds1.isEmpty()) {
            fields.addAll(fds1);
        }
        return fields;
    }

    public static Map<String, Field> getObjectAllFieldsMap(Class<?> cclz) {
        Map<String, Field> fds1;
        Class<?> pclz;
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Field[] fs = cclz.getDeclaredFields();
        if (fs != null && fs.length > 0) {
            for (Field f : fs) {
                if (ModelBuilder.isIgnoreField(f)) continue;
                fields.put(f.getName(), f);
                fields.put(f.getName().toUpperCase(), f);
            }
        }
        if ((pclz = cclz.getSuperclass()) != null && !pclz.isInterface() && (fds1 = ModelBuilder.getObjectAllFieldsMap(pclz)) != null && !fds1.isEmpty()) {
            fields.putAll(fds1);
        }
        return fields;
    }

    public static ModelFabric getModelFabric(String clzStr) {
        return ModelCacheManager.get().getModelFabric(clzStr);
    }

    public static String getModelTable(Class<?> clz) {
        Table table = clz.getAnnotation(Table.class);
        if (table != null) {
            return table.value();
        }
        return StrKit.enCodeUnderlined(clz.getSimpleName());
    }

    public static ModelFabric getModelFabric(Class<?> clz) {
        return ModelCacheManager.get().getModelFabric(clz);
    }

    public static String buildColumnsByExcluded(Class<?> clz, List<String> excludedColumns) {
        ModelFabric mf = ModelBuilder.getModelFabric(clz);
        Map<String, String> attrs = mf.getAttrMapping();
        HashSet<String> columns = new HashSet<String>();
        Set<Map.Entry<String, String>> kvsets = attrs.entrySet();
        for (Map.Entry<String, String> entry : kvsets) {
            if (excludedColumns.contains(entry.getKey()) || excludedColumns.contains(entry.getValue()) || excludedColumns.contains(entry.getValue().toLowerCase())) continue;
            columns.add(entry.getValue().toUpperCase());
        }
        StringBuilder sb = new StringBuilder();
        columns.forEach(k -> sb.append((String)k).append(","));
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

