/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.dialect.fs;

import cn.sylinx.hbatis.db.dialect.DbType;
import cn.sylinx.hbatis.db.dialect.fs.DefaultFluentSqlCreator;
import cn.sylinx.hbatis.db.dialect.fs.FluentSqlCreator;
import cn.sylinx.hbatis.db.dialect.fs.MysqlFluentSqlCreator;
import cn.sylinx.hbatis.db.dialect.fs.OracleFluentSqlCreator;
import cn.sylinx.hbatis.db.dialect.fs.SqlserverFluentSqlCreator;
import java.util.HashMap;
import java.util.Map;

public class FluentSqlCreatorFactory {
    private final Map<DbType, FluentSqlCreator> registers = new HashMap<DbType, FluentSqlCreator>();
    private static final FluentSqlCreatorFactory instance = new FluentSqlCreatorFactory();
    private final FluentSqlCreator defaultFluentSqlCreator = new DefaultFluentSqlCreator();

    public static FluentSqlCreatorFactory get() {
        return instance;
    }

    private FluentSqlCreatorFactory() {
        this.registerDefault();
    }

    private void registerDefault() {
        this.register(DbType.MYSQL, new MysqlFluentSqlCreator());
        this.register(DbType.ORACLE, new OracleFluentSqlCreator());
        this.register(DbType.SQLSERVER, new SqlserverFluentSqlCreator());
    }

    public void register(DbType dbType, FluentSqlCreator sqlBuilder) {
        this.registers.put(dbType, sqlBuilder);
    }

    public FluentSqlCreator getFluentSqlCreator(DbType dbType) {
        FluentSqlCreator sb = this.registers.get((Object)dbType);
        if (sb == null) {
            return this.defaultFluentSqlCreator;
        }
        return sb;
    }
}

