/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.common;

import cn.sylinx.hbatis.db.cache.CacheQuery;
import cn.sylinx.hbatis.db.common.BaseDbOper;
import cn.sylinx.hbatis.db.common.Callable;
import cn.sylinx.hbatis.db.common.DbOper;
import cn.sylinx.hbatis.db.common.DbPro;
import cn.sylinx.hbatis.db.common.DefaultCacheQuery;
import cn.sylinx.hbatis.db.common.HbatisService;
import cn.sylinx.hbatis.db.common.ITransaction;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.dialect.Dialect;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.ext.parse.SqlParser;
import cn.sylinx.hbatis.ext.res.ClasspathSqlResource;
import cn.sylinx.hbatis.kit.Ret;
import cn.sylinx.hbatis.kit.Tuple;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class DefaultHbatisService
implements HbatisService,
BaseDbOper {
    private final DbPro dbPro;
    private final CacheQuery cacheQuery;
    private final Map<String, HbatisService> map = new WeakHashMap<String, HbatisService>();

    public DefaultHbatisService() {
        this("_hbatis_default_jdbc_resource");
    }

    public DefaultHbatisService(String datasourceName) {
        this(DbPro.use(datasourceName));
    }

    private DefaultHbatisService(DbPro dbPro) {
        this.dbPro = dbPro;
        this.cacheQuery = this.createCacheQuery(new Object[0]);
        this.map.put(dbPro.getDataSourceName(), this);
    }

    @Override
    public String getDatasourceName() {
        return this.dbPro.getDataSourceName();
    }

    @Override
    public Dialect getDialect() {
        return this.dbPro.getDialect();
    }

    @Override
    public <T> T call(Callable<T> callable) {
        return this.dbPro.call(callable);
    }

    private CacheQuery createCacheQuery(Object ... params) {
        return new DefaultCacheQuery(this.dbPro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HbatisService use(String jdbcResourceName) {
        HbatisService dbService = this.map.get(jdbcResourceName);
        if (dbService == null) {
            String string = jdbcResourceName.intern();
            synchronized (string) {
                this.createInstanceInner(jdbcResourceName);
            }
            dbService = this.map.get(jdbcResourceName);
        }
        return dbService;
    }

    private void createInstanceInner(String jdbcResourceName) {
        HbatisService dbService = this.map.get(jdbcResourceName);
        if (dbService == null) {
            dbService = new DefaultHbatisService(DbPro.use(jdbcResourceName));
            this.map.put(jdbcResourceName, dbService);
        }
    }

    @Override
    public CacheQuery withCache() {
        if (this.cacheQuery == null) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7f13\u5b58\u67e5\u8be2");
        }
        return this.cacheQuery;
    }

    protected CacheQuery getCacheQuery() {
        return this.cacheQuery;
    }

    @Override
    public boolean transaction(ITransaction transaction) {
        return this.dbPro.transaction(transaction);
    }

    @Override
    public Ret transactionWithReturn(ITransaction transaction) {
        return this.dbPro.transactionWithReturn(transaction);
    }

    @Override
    public <T> List<T> query(String sql, QueryMapper<T> mapper, Object ... params) {
        return this.dbPro.query(sql, mapper, params);
    }

    @Override
    public <T> T queryFirst(String sql, QueryMapper<T> mapper, Object ... params) {
        return this.dbPro.queryFirst(sql, mapper, params);
    }

    @Override
    public List<Object[]> query(String sql, Object ... params) {
        return this.dbPro.query(sql, params);
    }

    @Override
    public List<Map<String, Object>> queryMap(String sql, Object ... params) {
        return this.dbPro.queryMap(sql, params);
    }

    @Override
    public Object[] queryFirst(String sql, Object ... params) {
        return this.dbPro.queryFirst(sql, params);
    }

    @Override
    public Map<String, Object> queryFirstMap(String sql, Object ... params) {
        return this.dbPro.queryFirstMap(sql, params);
    }

    @Override
    public Serializable save(String insertSql, Object ... params) {
        return this.dbPro.save(insertSql, params);
    }

    @Override
    public int update(String updateSql, Object ... params) {
        return this.dbPro.update(updateSql, params);
    }

    @Override
    public Serializable updateWithReturnPk(String updateSql, Object ... params) {
        return this.dbPro.updateWithReturnPk(updateSql, params);
    }

    @Override
    public int[] batch(List<String> sql) {
        return this.dbPro.batch(sql);
    }

    @Override
    public int[] batch(String sql, Object[][] params) {
        return this.dbPro.batch(sql, params);
    }

    @Override
    public int[] batch(String sql, Object[][] params, int batchSize) {
        return this.dbPro.batch(sql, params, batchSize);
    }

    @Override
    public int[] batch(List<String> sqlList, int batchSize) {
        return this.dbPro.batch(sqlList, batchSize);
    }

    @Override
    public <T> int update(T t) {
        return this.dbPro.update(t);
    }

    @Override
    public <T> Serializable save(T t) {
        return this.dbPro.save(t);
    }

    @Override
    public <T> int delete(T t) {
        return this.dbPro.delete(t);
    }

    @Override
    public Record queryFirstRecord(String sql, Object ... params) {
        return this.dbPro.queryFirstRecord(sql, params);
    }

    @Override
    public List<Record> queryRecords(String sql, Object ... params) {
        return this.dbPro.queryRecords(sql, params);
    }

    @Override
    public boolean execute(String exeSql, Object ... params) {
        return this.dbPro.execute(exeSql, params);
    }

    @Override
    public boolean executeLargeUpdate(List<String> exeSqlList) {
        return this.dbPro.executeLargeUpdate(exeSqlList);
    }

    @Override
    public DbOper getDbOper() {
        return this;
    }

    @Override
    public boolean existTable(String schema, String table) {
        return this.dbPro.existTable(schema, table);
    }

    @Override
    public boolean existTableColumn(String schema, String table, String column) {
        return this.dbPro.existTableColumn(schema, table, column);
    }

    @Override
    public <T> List<T> queryObject(String sql, Class<T> clazz, Object ... params) {
        return this.dbPro.queryObject(sql, clazz, params);
    }

    @Override
    public <T> T queryFirstObject(String sql, Class<T> clazz, Object ... params) {
        return this.dbPro.queryFirstObject(sql, clazz, params);
    }

    @Override
    public <T> List<T> query(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> clz) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return this.use(this.getDatasourceName()).query(st, mapper, pms);
    }

    @Override
    public <T> List<T> queryObjectList(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> clz) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.use(this.getDatasourceName()).queryObject(st, clz, pms);
    }

    @Override
    public <T> T queryFirstObject(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> clz) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.use(this.getDatasourceName()).queryFirstObject(st, clz, pms);
    }

    @Override
    public List<Map<String, Object>> queryForMapList(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.use(this.getDatasourceName()).queryMap(st, pms);
    }

    @Override
    public List<Record> queryForRecords(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.use(this.getDatasourceName()).queryRecords(st, pms);
    }

    @Override
    public Record queryFirstRecord(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.use(this.getDatasourceName()).queryFirstRecord(st, pms);
    }

    @Override
    public List<Object[]> queryObjectArrayList(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.use(this.getDatasourceName()).query(st, pms);
    }

    @Override
    public Object[] queryFirstObjectArray(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.use(this.getDatasourceName()).queryFirst(st, pms);
    }

    @Override
    public Map<String, Object> queryFirstForMap(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.use(this.getDatasourceName()).queryFirstMap(st, pms);
    }

    @Override
    public <T> T queryFirst(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> clz) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return this.use(this.getDatasourceName()).queryFirst(st, mapper, pms);
    }

    @Override
    public int update(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.use(this.getDatasourceName()).update(st, pms);
    }

    @Override
    public boolean execute(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.use(this.getDatasourceName()).execute(st, pms);
    }

    @Override
    public int delete(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.use(this.getDatasourceName()).update(st, pms);
    }

    @Override
    public Object save(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.use(this.getDatasourceName()).save(st, pms);
    }
}

