/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.common;

import cn.sylinx.hbatis.db.cache.CacheKeyGenerator;
import cn.sylinx.hbatis.db.cache.CacheQuery;
import cn.sylinx.hbatis.db.cache.ICacheKit;
import cn.sylinx.hbatis.db.cache.IDataLoader;
import cn.sylinx.hbatis.db.common.DbPro;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.ext.parse.SqlParser;
import cn.sylinx.hbatis.ext.res.ClasspathSqlResource;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.kit.Tuple;
import cn.sylinx.hbatis.log.GLog;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultCacheQuery
implements CacheQuery {
    private final DbPro dbPro;
    private ICacheKit cacheKit;
    private Map<String, String> cachedKey = new HashMap<String, String>();

    public DefaultCacheQuery(DbPro dbPro) {
        this.dbPro = dbPro;
        this.cacheKit = ICacheKit.create();
    }

    public String getSqlMD5(String key) {
        if (this.cachedKey.containsKey(key)) {
            return this.cachedKey.get(key);
        }
        if (StrKit.isEmpty(key)) {
            return "";
        }
        MessageDigest digest = null;
        byte[] buffer = key.getBytes(Charset.defaultCharset());
        try {
            digest = MessageDigest.getInstance("MD5");
            digest.update(buffer);
        }
        catch (Exception e) {
            GLog.error("md5 encode error", e);
            throw new HbatisException(e);
        }
        BigInteger bigInt = new BigInteger(1, digest.digest());
        String ecodeStr = bigInt.toString(16);
        this.cachedKey.put(key, ecodeStr);
        return ecodeStr;
    }

    @Override
    public Record queryFirstRecord(final String sql, final Object ... params) {
        if (!this.cacheKit.isInited()) {
            GLog.debug("no cache config, query from db", new Object[0]);
            return this.dbPro.queryFirstRecord(sql, params);
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q1", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        GLog.debug("use cache query[Q1]: 'public Record queryFirstRecord(final String sql, final Object... params)' , cache key:{}", cacheKey);
        return (Record)this.cacheKit.get(cacheKey, new IDataLoader(){

            @Override
            public Record load() {
                return DefaultCacheQuery.this.dbPro.queryFirstRecord(sql, params);
            }
        });
    }

    @Override
    public List<Record> queryRecords(final String sql, final Object ... params) {
        if (!this.cacheKit.isInited()) {
            GLog.debug("no cache config, query from db", new Object[0]);
            return this.dbPro.queryRecords(sql, params);
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q2", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        GLog.debug("use cache query[Q2]: 'public List<Record> queryRecords(final String sql, final Object... params)', cache key:{}", cacheKey);
        return (List)this.cacheKit.get(cacheKey, new IDataLoader(){

            @Override
            public List<Record> load() {
                return DefaultCacheQuery.this.dbPro.queryRecords(sql, params);
            }
        });
    }

    @Override
    public List<Object[]> query(final String sql, final Object ... params) {
        if (!this.cacheKit.isInited()) {
            GLog.debug("no cache config, query from db", new Object[0]);
            return this.dbPro.query(sql, params);
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q3", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        GLog.debug("use cache query[Q3]: 'public List<Object[]> query(final String sql, final Object... params)', cache key:{}", cacheKey);
        return (List)this.cacheKit.get(cacheKey, new IDataLoader(){

            @Override
            public List<Object[]> load() {
                return DefaultCacheQuery.this.dbPro.query(sql, params);
            }
        });
    }

    @Override
    public List<Map<String, Object>> queryMap(final String sql, final Object ... params) {
        if (!this.cacheKit.isInited()) {
            GLog.debug("no cache config, query from db", new Object[0]);
            return this.dbPro.queryMap(sql, params);
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q4", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        GLog.debug("use cache query[Q4]: 'public List<Map<String, Object>> queryMap(final String sql, final Object... params)', cache key:{}", cacheKey);
        return (List)this.cacheKit.get(cacheKey, new IDataLoader(){

            @Override
            public List<Map<String, Object>> load() {
                return DefaultCacheQuery.this.dbPro.queryMap(sql, params);
            }
        });
    }

    @Override
    public Object[] queryFirst(final String sql, final Object ... params) {
        if (!this.cacheKit.isInited()) {
            GLog.debug("no cache config, query from db", new Object[0]);
            return this.dbPro.queryFirst(sql, params);
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q5", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        GLog.debug("use cache query[Q5]: 'public Object[] queryFirst(final String sql, final Object... params)', cache key:{}", cacheKey);
        return (Object[])this.cacheKit.get(cacheKey, new IDataLoader(){

            public Object[] load() {
                return DefaultCacheQuery.this.dbPro.queryFirst(sql, params);
            }
        });
    }

    @Override
    public Map<String, Object> queryFirstMap(final String sql, final Object ... params) {
        if (!this.cacheKit.isInited()) {
            GLog.debug("no cache config, query from db", new Object[0]);
            return this.dbPro.queryFirstMap(sql, params);
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q6", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        GLog.debug("use cache query[Q6]: 'public Map<String, Object> queryFirstMap(final String sql, final Object... params)', cache key:{}", cacheKey);
        return (Map)this.cacheKit.get(cacheKey, new IDataLoader(){

            @Override
            public Map<String, Object> load() {
                return DefaultCacheQuery.this.dbPro.queryFirstMap(sql, params);
            }
        });
    }

    @Override
    public <T> List<T> query(final String sql, final QueryMapper<T> mapper, final Object ... params) {
        if (!this.cacheKit.isInited()) {
            GLog.debug("no cache config, query from db", new Object[0]);
            return this.dbPro.query(sql, mapper, params);
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q7", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        GLog.debug("use cache query[Q7]: 'public <T> List<T> query(final String sql, final QueryMapper<T> mapper, final Object... params)', cache key:{}", cacheKey);
        return (List)this.cacheKit.get(cacheKey, new IDataLoader(){

            @Override
            public List<T> load() {
                return DefaultCacheQuery.this.dbPro.query(sql, mapper, params);
            }
        });
    }

    @Override
    public <T> T queryFirst(final String sql, final QueryMapper<T> mapper, final Object ... params) {
        if (!this.cacheKit.isInited()) {
            GLog.debug("no cache config, query from db", new Object[0]);
            return this.dbPro.queryFirst(sql, mapper, params);
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q8", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        GLog.debug("use cache query[Q8]: 'public <T> T queryFirst(final String sql, final QueryMapper<T> mapper, final Object... params)', cache key:{}", cacheKey);
        return this.cacheKit.get(cacheKey, new IDataLoader(){

            public T load() {
                return DefaultCacheQuery.this.dbPro.queryFirst(sql, mapper, params);
            }
        });
    }

    @Override
    public <T> List<T> queryObject(final String sql, final Class<T> clazz, final Object ... params) {
        if (!this.cacheKit.isInited()) {
            GLog.debug("no cache config, query from db", new Object[0]);
            return this.dbPro.queryObject(sql, clazz, params);
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q9", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        GLog.debug("use cache query[Q9]: 'public <T> List<T> queryObject(String sql, Class<T> clazz, Object... params)', cache key:{}", cacheKey);
        return (List)this.cacheKit.get(cacheKey, new IDataLoader(){

            @Override
            public List<T> load() {
                return DefaultCacheQuery.this.dbPro.queryObject(sql, clazz, params);
            }
        });
    }

    @Override
    public <T> T queryFirstObject(String sql, Class<T> clazz, Object ... params) {
        List<T> dataList = this.queryObject(sql, clazz, params);
        return dataList.isEmpty() ? null : (T)dataList.get(0);
    }

    @Override
    public List<Map<String, Object>> queryForMapList(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.queryMap(st, pms);
    }

    @Override
    public List<Record> queryForRecords(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.queryRecords(st, pms);
    }

    @Override
    public Record queryFirstRecord(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.queryFirstRecord(st, pms);
    }

    @Override
    public List<Object[]> queryObjectArrayList(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.query(st, pms);
    }

    @Override
    public Object[] queryFirstObjectArray(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.queryFirst(st, pms);
    }

    @Override
    public Map<String, Object> queryFirstForMap(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.queryFirstMap(st, pms);
    }

    @Override
    public <T> List<T> query(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> clz) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return this.query(st, mapper, pms);
    }

    @Override
    public <T> T queryFirst(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> clz) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return this.queryFirst(st, mapper, pms);
    }

    @Override
    public <T> List<T> queryObjectList(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> clz) {
        Tuple tp = SqlParser.parseSql(sqlResource, params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.queryObject(st, clz, pms);
    }
}

