/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.starter.springboot.aspect;

import cn.sylinx.hbatis.exception.TransactionException;
import cn.sylinx.hbatis.ext.mirage.repository.DaoService;
import cn.sylinx.hbatis.ext.starter.springboot.aspect.Transactional;
import cn.sylinx.hbatis.ext.starter.util.DAO;
import cn.sylinx.hbatis.kit.Ret;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TransactionAspect {
    @Pointcut(value="@annotation(cn.sylinx.hbatis.ext.starter.springboot.aspect.Transactional)")
    public void hbatisTransactionalAspect() {
    }

    @Around(value="hbatisTransactionalAspect()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        GLog.debug("hbatisTransactionalAspect bingo", new Object[0]);
        Class<?> targetClass = pjp.getTarget().getClass();
        String methodName = pjp.getSignature().getName();
        Class<?>[] parameterTypes = ((MethodSignature)pjp.getSignature()).getMethod().getParameterTypes();
        Method method = targetClass.getMethod(methodName, parameterTypes);
        Transactional trans = method.getAnnotation(Transactional.class);
        DaoService daoService = StrKit.isBlank(trans.datasource()) ? DAO.mirage() : DAO.mirage(trans.datasource());
        Ret r = daoService.transactionWithReturn(() -> {
            Ret result = Ret.success();
            try {
                result.setData(pjp.proceed());
            }
            catch (Throwable e) {
                String msg = StrKit.isBlank(e.getMessage()) || e.getMessage() == "null" ? "\u6267\u884c\u4e8b\u52a1\u5f02\u5e38" : e.getMessage();
                return Ret.error(msg);
            }
            return result;
        });
        if (r.isSuccess()) {
            return r.getData();
        }
        throw new TransactionException(r.getError());
    }
}

