/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.starter.springboot;

import cn.sylinx.hbatis.db.dialect.DbType;
import cn.sylinx.hbatis.ds.DataSourceWrapper;
import cn.sylinx.hbatis.ext.mirage.plugin.SqlResourcePreloadPlugin;
import cn.sylinx.hbatis.ext.starter.pool.DataSourceWrapperFactory;
import cn.sylinx.hbatis.ext.starter.springboot.RelaxedPropertyResolver;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.IPlugin;
import cn.sylinx.hbatis.plugin.PluginStarter;
import cn.sylinx.hbatis.plugin.datasource.DataSourcePlugin;
import cn.sylinx.hbatis.plugin.ehcache.EhcachePlugin;
import cn.sylinx.hbatis.plugin.model.ModelPreloadPlugin;
import cn.sylinx.hbatis.plugin.proxy.ProxyPlugin;
import cn.sylinx.hbatis.plugin.statement.StatementHandlerPlugin;
import cn.sylinx.hbatis.plugin.transaction.TransactionIsolationPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

class HbatisWithCurrentDatasourceInitializationBean {
    HbatisWithCurrentDatasourceInitializationBean() {
    }

    private DataSourceWrapper buildDataSource(Map<String, Object> dsMap, Map<String, Object> extConfig) {
        return DataSourceWrapperFactory.buildDataSource(dsMap, extConfig);
    }

    private void initMultiDataSources(ArrayList<IPlugin> pluginList, Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.datasource.multi.");
        String dsPrefixs = propertyResolver.getProperty("names");
        if (dsPrefixs == null || "".equals(dsPrefixs)) {
            return;
        }
        for (String dsPrefix : dsPrefixs.split(",")) {
            Map<String, Object> dsMap = propertyResolver.getSubProperties(dsPrefix + ".");
            Map<String, Object> extConfig = propertyResolver.getSubProperties(dsPrefix + ".config.");
            DataSourceWrapper ds = this.buildDataSource(dsMap, extConfig);
            DataSourcePlugin ptmp = new DataSourcePlugin();
            ptmp.setJdbcResourceName(dsPrefix);
            ptmp.setDataSourceWrapper(ds);
            pluginList.add(ptmp);
        }
    }

    public PluginStarter init(DataSource dataSource, Environment env) {
        IPlugin initProxyPlugin;
        IPlugin initTransactionPlugin;
        IPlugin initStatementHandlerPlugin;
        IPlugin initSqlResourcePreloadPlugin;
        IPlugin initEhcachePlugin;
        String dbtype = env.getProperty("hbatis.ds.dbtype", DbType.MYSQL.getValue());
        PluginStarter ps = new PluginStarter();
        DataSourcePlugin dsp = new DataSourcePlugin();
        dsp.setDataSourceWrapper(DataSourceWrapper.create(dataSource, DbType.getDbType(dbtype)));
        ArrayList<IPlugin> pluginList = new ArrayList<IPlugin>();
        pluginList.add(dsp);
        this.initMultiDataSources(pluginList, env);
        IPlugin initModelPreLoadPlugin = this.initModelPreLoadPlugin(env);
        if (initModelPreLoadPlugin != null) {
            pluginList.add(initModelPreLoadPlugin);
        }
        if ((initEhcachePlugin = this.initEhcachePlugin(env)) != null) {
            pluginList.add(initEhcachePlugin);
        }
        if ((initSqlResourcePreloadPlugin = this.initSqlResourcePreloadPlugin(env)) != null) {
            pluginList.add(initSqlResourcePreloadPlugin);
        }
        if ((initStatementHandlerPlugin = this.initStatementHandlerPlugin(env)) != null) {
            pluginList.add(initStatementHandlerPlugin);
        }
        if ((initTransactionPlugin = this.initTransactionPlugin(env)) != null) {
            pluginList.add(initTransactionPlugin);
        }
        if ((initProxyPlugin = this.initProxyPlugin(env)) != null) {
            pluginList.add(initProxyPlugin);
        }
        ps.setPluginList(pluginList);
        ps.start();
        GLog.info("hbatis\u5df2\u4f7f\u7528\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\uff08\u9ed8\u8ba4\uff09\uff0c\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + dbtype, new Object[0]);
        return ps;
    }

    private IPlugin initProxyPlugin(Environment env) {
        String[] clzArray;
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.proxy.");
        String clzList = propertyResolver.getProperty("class");
        if (StrKit.isBlank(clzList)) {
            return null;
        }
        ProxyPlugin plugin = new ProxyPlugin();
        for (String clz : clzArray = clzList.split(",")) {
            if (!StrKit.isNotBlank(clz)) continue;
            IPlugin item = null;
            try {
                item = (IPlugin)Class.forName(clz.trim()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                GLog.error("\u521d\u59cb\u5316\u63d2\u4ef6\u5931\u8d25, clz: " + clz, e);
            }
            if (item == null) continue;
            plugin.addPlugin(item);
        }
        return plugin;
    }

    private IPlugin initModelPreLoadPlugin(Environment env) {
        String scanPackageList;
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.modelpreload.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return null;
        }
        GLog.debug("ModelPreloadPlugin inited.", new Object[0]);
        ModelPreloadPlugin mp = new ModelPreloadPlugin();
        String acmStrategy = propertyResolver.getProperty("acmStrategy");
        if (StrKit.isNotBlank(acmStrategy)) {
            mp.setAcmStrategyClass(acmStrategy);
        }
        if (StrKit.isNotBlank(scanPackageList = propertyResolver.getProperty("scanPackageList"))) {
            GLog.debug("ModelPreloadPlugin scanPackageList:{}", scanPackageList);
            String[] pkgArray = scanPackageList.split(",");
            mp.setScanPackageList(Arrays.asList(pkgArray));
        }
        return mp;
    }

    private IPlugin initEhcachePlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.ehcache.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return null;
        }
        GLog.debug("EhcachePlugin inited.", new Object[0]);
        return new EhcachePlugin();
    }

    private IPlugin initSqlResourcePreloadPlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.mirage.");
        String path = propertyResolver.getProperty("sqlpath");
        if (StrKit.isBlank(path)) {
            return null;
        }
        GLog.debug("SqlResourcePreloadPlugin inited.", new Object[0]);
        String[] pathArray = path.split(",");
        List<String> pathList = Arrays.asList(pathArray);
        SqlResourcePreloadPlugin plugin = new SqlResourcePreloadPlugin(pathList);
        return plugin;
    }

    private IPlugin initStatementHandlerPlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.statement.");
        String statementHandlerClass = propertyResolver.getProperty("clazz");
        if (StrKit.isBlank(statementHandlerClass)) {
            return null;
        }
        GLog.debug("StatementHandlerPlugin inited.", new Object[0]);
        StatementHandlerPlugin shp = new StatementHandlerPlugin();
        shp.setStatementHandlerClass(statementHandlerClass);
        return shp;
    }

    private IPlugin initTransactionPlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.transaction.");
        String level = propertyResolver.getProperty("level");
        if (StrKit.isBlank(level)) {
            return null;
        }
        GLog.debug("TransactionIsolationPlugin inited.", new Object[0]);
        int levelInt = Integer.parseInt(level);
        TransactionIsolationPlugin plugin = new TransactionIsolationPlugin(levelInt);
        return plugin;
    }
}

