package cn.sylinx.hbatis.plugin.model;

import java.util.HashMap;
import java.util.Map;

import cn.sylinx.hbatis.db.mapper.acm.AcmStrategy;
import cn.sylinx.hbatis.log.GLog;

public enum ModelConst {

	ME;

	/**
	 * 全局模型字段映射策略
	 */
	public static final String KEY_ACM_STRATEGY = "ACM_STRATEGY";

	Map<String, Object> params = new HashMap<>();

	public Object getConst(String key) {
		return params.get(key);
	}

	/**
	 * 获取全局模型字段映射策略
	 * 
	 * @return
	 */
	public AcmStrategy getAcmStrategy() {
		return (AcmStrategy) params.get(KEY_ACM_STRATEGY);
	}

	public void setAcmStrategy(String acmStrategy) {

		AcmStrategy acmStrategyEntity = getAcmStrategy();

		if (acmStrategyEntity != null) {
			GLog.error("参数ACM_STRATEGY只能被设置一次");
			return;
		}

		try {
			Class<?> acmStrategyClz = Class.forName(acmStrategy);
			Object inst = acmStrategyClz.newInstance();
			if (inst instanceof AcmStrategy) {
				GLog.info("全局模型字段映射策略{}已加载", acmStrategy);
				params.put(KEY_ACM_STRATEGY, inst);
			}

		} catch (ClassNotFoundException | InstantiationException | IllegalAccessException e) {
			GLog.error("异常:", e);
		}

	}

}
