package cn.sylinx.hbatis.plugin.datasource;

import cn.sylinx.hbatis.ds.DataSourceWrapper;
import cn.sylinx.hbatis.ds.JdbcResource;
import cn.sylinx.hbatis.ds.JdbcResourceWrapper;
import cn.sylinx.hbatis.kit.StrKit;

public class DataSourcePlugin extends JdbcResourcePlugin {

	private String jdbcResourceName;

	private DataSourceWrapper dataSourceWrapper;

	@Override
	public JdbcResourceWrapper createJdbcResourceWrapper(Object... objects) {

		boolean defaultJdbcResource = false;

		if (StrKit.isBlank(jdbcResourceName)) {
			jdbcResourceName = JdbcResourcePlugin.DEFAULT_JDBC_RESOURCE_NAME;
			defaultJdbcResource = true;
		}

		JdbcResourceWrapper jrw = new JdbcResourceWrapper();
		jrw.setDefaultResource(defaultJdbcResource);
		jrw.setJdbcResource(new JdbcResource(jdbcResourceName, dataSourceWrapper));
		jrw.setResourceName(jdbcResourceName);

		return jrw;
	}

	public DataSourcePlugin setJdbcResourceName(String jdbcResourceName) {
		this.jdbcResourceName = jdbcResourceName;
		return this;
	}

	public DataSourcePlugin setDataSourceWrapper(DataSourceWrapper dataSourceWrapper) {
		this.dataSourceWrapper = dataSourceWrapper;
		return this;
	}

	public DataSourcePlugin() {

	}

}
