package cn.sylinx.hbatis.kit;

import java.io.Serializable;

public class Ret implements Serializable {

	private boolean success = false;

	private String error;

	private Object data;

	public Ret() {

	}

	public Ret(boolean success, String error, Object data) {
		this.success = success;
		this.error = error;
		this.data = data;
	}

	public static Ret error() {
		return new Ret(false, "执行失败", null);
	}

	public static Ret error(String error) {
		return new Ret(false, error, null);
	}

	public static Ret success() {
		return new Ret(true, "成功执行", null);
	}

	public static Ret success(Object data) {
		return new Ret(true, "成功执行", data);
	}

	public boolean isSuccess() {
		return success;
	}

	public void setSuccess(boolean success) {
		this.success = success;
	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}

	public Object getData() {
		return data;
	}

	public void setData(Object data) {
		this.data = data;
	}

}
