package cn.sylinx.hbatis.kit;

import cn.sylinx.hbatis.exception.HbatisException;

@SuppressWarnings("serial")
public class Pair extends Tuple {

	public static Pair of(Object key, Object value) {
		return new Pair(key, value);
	}

	public static Pair apply(Object key, Object value) {
		return of(key, value);
	}

	public Pair(Object key, Object value) {
		super(new Object[] { key, value });
	}

	public <T> T getKey() {
		return getObject(0);
	}

	public <T> T getValue() {
		return getObject(1);
	}

	public <T> T getKey(Class<T> clz) {
		return getObject(0);
	}

	public <T> T getValue(Class<T> clz) {
		return getObject(1);
	}

	@Override
	public void setItems(Object[] items) {

		if (items == null || items.length != 2) {
			throw new HbatisException("not pair");
		}

		super.setItems(items);
	}

}
