package cn.sylinx.hbatis.ext.tool;

import java.util.Objects;

import cn.sylinx.hbatis.db.dialect.DbType;

public class RepositoryTools {

	private static final RepositoryTools instance = new RepositoryTools();

	private RepositoryTools() {

	}

	public static RepositoryTools getInstance() {
		return instance;
	}

	public String generateTableDdlSql(DbType dbType, Class<?> clz) {
		Objects.requireNonNull(dbType);

		switch (dbType) {
		case MYSQL:
			return generateMysqlTableDdlSql(clz);
		case ORACLE:
			return generateOracleTableDDL(clz);
		case SQLSERVER:
			return generateSqlserverTableDDL(clz);
		default:
			throw new UnsupportedOperationException("该数据库" + dbType + "不支持此操作");
		}
	}

	public String generateAddTableColumnDDL(DbType dbType, Class<?> clz, String prop) {

		Objects.requireNonNull(dbType);

		switch (dbType) {
		case MYSQL:
			return generateMysqlAddTableColumnDDL(clz, prop);
		case ORACLE:
			return generateOracleAddTableColumnDDL(clz, prop);
		case SQLSERVER:
			return generateSqlserverAddTableColumnDDL(clz, prop);
		default:
			throw new UnsupportedOperationException("该数据库" + dbType + "不支持此操作");
		}
	}

	public String generateModifyTableColumnDDL(DbType dbType, Class<?> clz, String prop) {

		Objects.requireNonNull(dbType);

		switch (dbType) {
		case MYSQL:
			return generateMysqlModifyTableColumnDDL(clz, prop);
		case ORACLE:
			return generateOracleModifyTableColumnDDL(clz, prop);
		case SQLSERVER:
			return generateSqlserverModifyTableColumnDDL(clz, prop);
		default:
			throw new UnsupportedOperationException("该数据库" + dbType + "不支持此操作");
		}
	}

	private String generateSqlserverModifyTableColumnDDL(Class<?> clz, String prop) {
		return new SqlserverRepositoryUtil(clz).generateModifyTableColumnDDL(prop);
	}

	private String generateSqlserverTableDDL(Class<?> clz) {
		return new SqlserverRepositoryUtil(clz).generateSql();
	}

	private String generateSqlserverAddTableColumnDDL(Class<?> clz, String prop) {
		return new SqlserverRepositoryUtil(clz).generateAddTableColumnDDL(prop);
	}

	private String generateMysqlTableDdlSql(Class<?> clz) {
		return new MysqlRepositoryUtil(clz).generateSql();
	}

	private String generateOracleTableDDL(Class<?> clz) {
		return new OracleRepositoryUtil(clz).generateSql();
	}

	private String generateMysqlAddTableColumnDDL(Class<?> clz, String prop) {
		return new MysqlRepositoryUtil(clz).generateAddTableColumnDDL(prop);
	}

	private String generateOracleAddTableColumnDDL(Class<?> clz, String prop) {
		return new OracleRepositoryUtil(clz).generateAddTableColumnDDL(prop);
	}

	private String generateMysqlModifyTableColumnDDL(Class<?> clz, String prop) {
		return new MysqlRepositoryUtil(clz).generateModifyTableColumnDDL(prop);
	}

	private String generateOracleModifyTableColumnDDL(Class<?> clz, String prop) {
		return new OracleRepositoryUtil(clz).generateModifyTableColumnDDL(prop);
	}
}
