package cn.sylinx.hbatis.ext.starter.springboot.aspect;

import java.lang.reflect.Method;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

import cn.sylinx.hbatis.exception.TransactionException;
import cn.sylinx.hbatis.ext.common.repository.CommonDaoService;
import cn.sylinx.hbatis.ext.starter.util.DAO;
import cn.sylinx.hbatis.kit.Ret;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;

@Aspect
@Component
public class TransactionAspect {

	@Pointcut("@annotation(cn.sylinx.hbatis.ext.starter.springboot.aspect.Transactional)")
	public void hbatisTransactionalAspect() {

	}

	@Around(value = "hbatisTransactionalAspect()")
	public Object doAround(ProceedingJoinPoint pjp) throws Throwable {

		GLog.debug("hbatisTransactionalAspect bingo");

		// 切点所在的类
		Class<?> targetClass = pjp.getTarget().getClass();
		// 使用了注解的方法
		String methodName = pjp.getSignature().getName();
		Class<?>[] parameterTypes = ((MethodSignature) pjp.getSignature()).getMethod().getParameterTypes();
		Method method = targetClass.getMethod(methodName, parameterTypes);
		Transactional trans = method.getAnnotation(Transactional.class);
		CommonDaoService daoService = StrKit.isBlank(trans.datasource()) ? DAO.hbatis()
				: DAO.hbatis(trans.datasource());

		Ret r = daoService.transactionWithReturn(() -> {

			Ret result = Ret.success();

			try {
				result.setData(pjp.proceed());
			} catch (Throwable e) {
				String msg = StrKit.isBlank(e.getMessage()) || e.getMessage() == "null" ? "执行事务异常" : e.getMessage();
				return Ret.error(msg);
			}

			return result;
		});

		if (r.isSuccess()) {
			return r.getData();
		}

		throw new TransactionException(r.getError());
	}

}
