package cn.sylinx.hbatis.ext.starter.springboot;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

import cn.sylinx.hbatis.plugin.PluginStarter;

/**
 * 
 * <pre>
    #spring boot 使用已存在数据源的配置方法（不能和hbatis.init=true同时存在）
	hbatis.ds.exist=true
	hbatis.ds.dbtype=mysql
	
    #XmapperPlugin是否开启，hbatis.plugin.xmapper.inited=true表示开启
	hbatis.plugin.xmapper.inited=true
	hbatis.plugin.xmapper.resourcePath=xmapper
	
	#ModelPreloadPlugin是否开启，hbatis.plugin.modelpreload.inited=true表示开启
	hbatis.plugin.modelpreload.inited=true
	hbatis.plugin.modelpreload.scanPackageList=cn.sylinx.hbatis.springboot.starter
	hbatis.plugin.modelpreload.acmStrategy=cn.sylinx.hbatis.db.mapper.acm.UnderlinedAcmStrategy
	
	#EhcachePlugin是否开启，hbatis.plugin.ehcache.inited=true表示开启
	hbatis.plugin.ehcache.inited=true
	
	#SqlResourcePreloadPlugin插件，sql文件预加载目录
	hbatis.plugin.mirage.sqlpath=sql,var
	
	#TransactionIsolationPlugin插件，设置事务级别: (1、2、4、8)
	hbatis.plugin.transaction.level=2
	
	#第三方插件，可使用代理插件启动（第三方插件类名称，多个使用逗号‘,’隔开）
	hbatis.plugin.proxy.class=
 * </pre>
 * 
 * @author han
 *
 */
@Configuration
public class HbatisAutoConfig {

	/**
	 * 使用现有数据源
	 * 
	 * @param dataSource
	 * @param env
	 * @return
	 */
	@Bean
	@ConditionalOnProperty(name = "hbatis.ds.exist", havingValue = "true")
	public PluginStarter pluginStarter1(@Autowired DataSource dataSource, @Autowired Environment env) {
		return new HbatisWithCurrentDatasourceInitializationBean().init(dataSource, env);
	}

	/**
	 * 使用配置数据源
	 * 
	 * @param dataSource
	 * @param env
	 * @return
	 */
	@Bean
	@ConditionalOnProperty(name = "hbatis.init", havingValue = "true")
	public PluginStarter pluginStarter2(@Autowired Environment env) {
		return new HbatisInitializationBean().init(env);
	}
}
