package cn.sylinx.hbatis.ext.starter.pool;

import java.beans.PropertyVetoException;

import com.mchange.v2.c3p0.ComboPooledDataSource;

import cn.sylinx.hbatis.log.GLog;

public class C3p0DataSourceCreator extends AbstractDataSourceCreator<ComboPooledDataSource> {

	@Override
	ComboPooledDataSource createBaseDataSource(String driver, String url, String username, String password,
			String dbType) {

		ComboPooledDataSource cds = new ComboPooledDataSource();
		cds.setJdbcUrl(url);
		try {
			cds.setDriverClass(driver);
		} catch (PropertyVetoException e) {
			GLog.error("driverClassName set error", e);
		}
		cds.setUser(username);
		cds.setPassword(password);
		return cds;
	}

}
