package cn.sylinx.hbatis.ext.mirage.repository;

import java.util.List;
import java.util.Map;

import cn.sylinx.hbatis.ext.mirage.spi.MirageServiceManager;
import cn.sylinx.hbatis.ext.res.ClasspathSqlResource;

public class BaseRepositoryImpl extends RepositoryImpl implements BaseRepository {

	public BaseRepositoryImpl() {

	}

	public BaseRepositoryImpl(String datasourceName) {
		super(datasourceName);
	}

	@Override
	public boolean execute(ClasspathSqlResource resource, Map<String, Object> params) {
		return MirageServiceManager.getMirageService().useService(getDatabase()).execute(resource, params);
	}

	@Override
	public boolean execute(ClasspathSqlResource resource) {
		return execute(resource, null);
	}

	@Override
	public <T> List<T> queryList(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz) {
		return MirageServiceManager.getMirageService().useService(getDatabase()).query(resource, params, clz);
	}

	@Override
	public <T> List<T> queryObjectList(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz) {
		return MirageServiceManager.getMirageService().useService(getDatabase()).queryObjectList(resource, params, clz);
	}

	@Override
	public <T> T queryFirstObject(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz) {
		return MirageServiceManager.getMirageService().useService(getDatabase()).queryFirstObject(resource, params,
				clz);
	}

	@Override
	public <T> List<T> queryList(ClasspathSqlResource resource, Class<T> clz) {
		return queryList(resource, null, clz);
	}

	@Override
	public <T> T queryFirst(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz) {
		return MirageServiceManager.getMirageService().useService(getDatabase()).queryFirst(resource, params, clz);
	}

	@Override
	public <T> T queryFirst(ClasspathSqlResource resource, Class<T> clz) {
		return queryFirst(resource, null, clz);
	}

	@Override
	public <T> List<T> queryListWithCache(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz) {
		return MirageServiceManager.getMirageService().useService(getDatabase()).withMirageCache().query(resource,
				params, clz);
	}

	@Override
	public <T> List<T> queryListWithCache(ClasspathSqlResource resource, Class<T> clz) {
		return queryListWithCache(resource, null, clz);
	}

	@Override
	public <T> T queryFirstWithCache(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz) {
		return MirageServiceManager.getMirageService().useService(getDatabase()).withMirageCache().queryFirst(resource,
				params, clz);
	}

	@Override
	public <T> T queryFirstWithCache(ClasspathSqlResource resource, Class<T> clz) {
		return queryFirstWithCache(resource, null, clz);
	}

}
