package cn.sylinx.hbatis.ext.mirage.repository;

import java.util.List;
import java.util.Map;

import cn.sylinx.hbatis.ext.res.ClasspathSqlResource;

public interface BaseRepository extends Repository {

	/**
	 * 执行脚本
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	boolean execute(ClasspathSqlResource resource, Map<String, Object> params);

	/**
	 * 执行脚本
	 * 
	 * @param resource
	 * @return
	 */
	boolean execute(ClasspathSqlResource resource);

	/**
	 * 查询对象列表
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	<T> List<T> queryList(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz);

	public <T> List<T> queryObjectList(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz) ;

	public <T> T queryFirstObject(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz);
	
	/**
	 * 查询对象列表
	 * 
	 * @param resource
	 * @return
	 */
	<T> List<T> queryList(ClasspathSqlResource resource, Class<T> clz);

	/**
	 * 查询对象
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	<T> T queryFirst(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz);

	/**
	 * 查询对象
	 * 
	 * @param resource
	 * @return
	 */
	<T> T queryFirst(ClasspathSqlResource resource, Class<T> clz);

	/**
	 * 查询对象列表
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	<T> List<T> queryListWithCache(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz);

	/**
	 * 查询对象列表
	 * 
	 * @param resource
	 * @return
	 */
	<T> List<T> queryListWithCache(ClasspathSqlResource resource, Class<T> clz);

	/**
	 * 查询对象
	 * 
	 * @param resource
	 * @param params
	 * @return
	 */
	<T> T queryFirstWithCache(ClasspathSqlResource resource, Map<String, Object> params, Class<T> clz);

	/**
	 * 查询对象
	 * 
	 * @param resource
	 * @return
	 */
	<T> T queryFirstWithCache(ClasspathSqlResource resource, Class<T> clz);

}
