package cn.sylinx.hbatis.ext.common.repository;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

import cn.sylinx.hbatis.db.common.Callable;
import cn.sylinx.hbatis.db.common.ITransaction;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.dialect.Dialect;
import cn.sylinx.hbatis.ext.model.BaseModel;
import cn.sylinx.hbatis.kit.Ret;

public interface CommonRepository {

	/**
	 * 获取数据库对应名称
	 * 
	 * @return
	 */
	String getDatabase();

	/**
	 * 获取数据库类型
	 * 
	 * @return
	 */
	Dialect getDialect();

	/**
	 * 自定义操作
	 * 
	 * @param callable
	 * @return
	 */
	public <T> T call(Callable<T> callable);

	/**
	 * 是否存在表
	 * 
	 * @param schema
	 * @param table
	 * @return
	 */
	public boolean existTable(final String schema, final String table);

	/**
	 * 是否存在字段
	 * 
	 * @param schema
	 * @param table
	 * @param column
	 * @return
	 */
	public boolean existTableColumn(final String schema, final String table, final String column);

	/**
	 * 执行脚本,包括ddl
	 * 
	 * @param resource
	 * @return
	 */
	boolean executeLargeUpdate(final List<String> exeSqlList);

	<T> List<T> queryList(String nativeSql, Class<T> clz, Object... params);

	<T> List<T> queryListWithCache(String nativeSql, Class<T> clz, Object... params);

	/**
	 * 保存对象，返回带有主键
	 * 
	 * @param t
	 * @return
	 */
	<T extends BaseModel> T save(T t);

	/**
	 * 插入语句
	 * 
	 * @param insertSql
	 * @param params
	 * @return
	 */
	public Serializable insert(final String insertSql, final Object... params);

	/**
	 * 返回无需主键
	 * 
	 * @param t
	 * @return
	 */
	<T extends BaseModel> boolean saveNoPk(T t);

	/**
	 * 保存通用对象，无主键返回
	 * 
	 * @param t
	 * @return
	 */
	<T> boolean saveObjectNoPk(T t);

	/**
	 * 保存通用对象，返回主键
	 * 
	 * @param t
	 * @return
	 */
	<T> Serializable saveObject(T t);

	/**
	 * 查询对应对象的所有值
	 * 
	 * @param clz
	 * @return
	 */
	<T> List<T> queryList(Class<T> clz);

	/**
	 * 更新对象
	 * 
	 * @param t
	 * @return
	 */
	<T extends BaseModel> int update(T t);

	/**
	 * 删除对象
	 * 
	 * @param t
	 * @return
	 */
	<T extends BaseModel> int delete(T t);

	/**
	 * 删除
	 * 
	 * @param id
	 * @param clz
	 * @return
	 */
	<T extends BaseModel> int delete(BigInteger id, Class<T> clz);

	/**
	 * 查询对应对象的所有值
	 * 
	 * @param clz
	 * @return
	 */
	<T> List<T> queryListWithCache(Class<T> clz);

	/**
	 * sql查询
	 * 
	 * @param sql
	 * @param params
	 * @return
	 */
	List<Record> queryRecords(String sql, Object... params);

	/**
	 * sql查询
	 * 
	 * @param sql
	 * @return
	 */
	List<Record> queryRecords(String sql);

	/**
	 * sql查询，单条
	 * 
	 * @param sql
	 * @param params
	 * @return
	 */
	Record queryRecord(String sql, Object... params);

	/**
	 * sql查询，单条
	 * 
	 * @param sql
	 * @return
	 */
	Record queryRecord(String sql);

	/**
	 * 更新
	 * 
	 * @param nativeSql
	 * @param params
	 * @return
	 */
	int update(String nativeSql, Object... params);

	/**
	 * sql查询
	 * 
	 * @param sql
	 * @param params
	 * @return
	 */
	List<Record> queryRecordsWithCache(String sql, Object... params);

	/**
	 * sql查询
	 * 
	 * @param sql
	 * @return
	 */
	List<Record> queryRecordsWithCache(String sql);

	/**
	 * sql查询，单条
	 * 
	 * @param sql
	 * @param params
	 * @return
	 */
	Record queryRecordWithCache(String sql, Object... params);

	/**
	 * sql查询，单条
	 * 
	 * @param sql
	 * @return
	 */
	Record queryRecordWithCache(String sql);

	/**
	 * 执行事务
	 * 
	 * @param transactions
	 * @return
	 */
	boolean transaction(ITransaction transactions);
	
	Ret transactionWithReturn(ITransaction transactions);

	public <T> List<T> queryObject(final String sql, final Class<T> clazz, final Object... params);

	public <T> T queryFirstObject(final String sql, final Class<T> clazz, final Object... params);
	
	/**
	 * 批量执行语句
	 * 
	 * @param sql
	 *            sql语句（更新、插入、删除）
	 * @return 影响行数
	 */
	public int[] batch(final List<String> sql);

	/**
	 * 批量执行语句
	 * 
	 * @param sql
	 *            sql语句（更新、插入、删除）
	 * @param params
	 *            参数
	 * @return 影响行数
	 */
	public int[] batch(final String sql, final Object[][] params);

	/**
	 * 批量执行语句
	 * 
	 * @param sql
	 *            sql语句（更新、插入、删除）
	 * @param params
	 *            参数
	 * @param batchSize
	 *            批量提交量
	 * @return 影响行数
	 */
	public int[] batch(final String sql, final Object[][] params, final int batchSize);

	/**
	 * 批量执行语句
	 * 
	 * @param sqlList
	 *            sql列表
	 * @param batchSize
	 *            批量提交量
	 * @return 影响行数
	 */
	public int[] batch(final List<String> sqlList, final int batchSize);
}
