package cn.sylinx.hbatis.db.mapper.acm;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.plugin.model.ModelFabric;

/**
 * 下划线策略
 * 
 * @author han
 *
 */
public class UnderlinedAcmStrategy implements AcmStrategy {

	@Override
	public Map<String, String> createAttrMapping(ModelFabric mf) {

		Map<String, String> attrMapping = new HashMap<String, String>();
		List<Field> fields = mf.getFields();

		for (Field f : fields) {

			String attr = f.getName();
			String column = convertUnderline(f.getName());

			attrMapping.put(attr, column);
			attrMapping.put(attr.toUpperCase(), column.toUpperCase());

		}

		return attrMapping;
	}

	private String convertUnderline(String attrName) {
		return StrKit.enCodeUnderlined(attrName);
	}
}
