package cn.sylinx.hbatis.db.dialect.sql;

import java.util.HashMap;
import java.util.Map;

import cn.sylinx.hbatis.db.dialect.DbType;

public class SqlBuilderFactory {

	private final Map<DbType, SqlBuilder> registers = new HashMap<DbType, SqlBuilder>();

	private static final SqlBuilderFactory instance = new SqlBuilderFactory();

	public static SqlBuilderFactory get() {
		return instance;
	}

	private SqlBuilderFactory() {
		registerDefault();
	}

	/**
	 * 注册 SqlBuilder
	 */
	private void registerDefault() {

		register(DbType.MYSQL, new MysqlSqlBuilder());
		register(DbType.ORACLE, new OracleSqlBuilder());
		register(DbType.SQLSERVER, new SqlServerSqlBuilder());
		register(DbType.DERBY, new DerbySqlBuilder());
		register(DbType.DB2, new DB2SqlBuilder());
		register(DbType.POSTGRESQL, new PostgreSQLSqlBuilder());
		register(DbType.H2, new H2SqlBuilder());
		register(DbType.CLICKHOUSE, new ClickHouseSqlBuilder());
	}

	public void register(DbType dbType, SqlBuilder sqlBuilder) {
		registers.put(dbType, sqlBuilder);
	}

	public SqlBuilder getSqlBuilder(DbType dbType) {
		SqlBuilder sb = registers.get(dbType);
		if (sb == null) {
			sb = new DefaultSqlBuilder();
		}
		return sb;
	}
}
