package cn.sylinx.hbatis.db.dialect.sql;

import cn.sylinx.hbatis.kit.Tuple;

public class PostgreSQLSqlBuilder extends DefaultSqlBuilder {

	@Override
	protected String[] getEscapeChar() {
		return new String[] { "\"", "\"" };
	}

	@Override
	public Tuple buildPaginatorSql(String preSql, int pageNumber, int pageSize) {

		String sqlCount = "select count(1) as totalCount from (" + preSql + ") as temp";
		String sql = preSql + " limit ? offset ? ";
		int offset = pageSize * (pageNumber - 1);
		Object[] params = new Object[] { pageSize, offset };
		return Tuple.apply(sqlCount, sql, params);
	}
}
