package cn.sylinx.hbatis.db.dialect;

import cn.sylinx.hbatis.db.common.FS;
import cn.sylinx.hbatis.db.common.fs.OracleFS;

public class OracleDialect extends DefaultDialect {

	@Override
	public DbType getDbType() {
		return DbType.ORACLE;
	}

	@Override
	public <T> FS<T> createFluentSql(Class<T> clazz) {
		return OracleFS.of(clazz);
	}

}
