package cn.sylinx.hbatis.db.common.fs;

import cn.sylinx.hbatis.db.common.FS;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;

public class OracleFS<T> extends FS<T> {

	public static <T> OracleFS<T> of(Class<T> modelClass) {
		return new OracleFS<T>().init(modelClass);
	}

	public OracleFS<T> init(Class<T> modelClass) {
		super.init(modelClass);
		this.tableName = preEscape + ModelBuilder.getModelFabric(modelClass).getTableName().toUpperCase() + postEscape;
		return this;
	}

	@Override
	protected String[] getEscape() {
		return new String[] { "\"", "\"" };
	}
}
