package cn.sylinx.hbatis.db.common;

import java.util.List;

import cn.sylinx.hbatis.db.mapper.QueryMapper;

/**
 * Mapper查询类
 * 
 * @author han
 *
 */
public interface MapperQuery {

	/**
	 * 使用Mapper查询
	 * 
	 * @param sql
	 *            sql语句
	 * @param mapper
	 *            查询mapper
	 * @param params
	 *            参数
	 * @return List<T>
	 */
	public <T> List<T> query(final String sql, final QueryMapper<T> mapper, final Object... params);

	/**
	 * 使用Mapper查询第一条记录
	 * 
	 * @param sql
	 *            sql语句
	 * @param mapper
	 *            查询mapper
	 * @param params
	 *            参数
	 * @return List<T>
	 */
	public <T> T queryFirst(final String sql, final QueryMapper<T> mapper, final Object... params);

}
