package cn.sylinx.hbatis.db.common;

import java.sql.SQLException;

import cn.sylinx.hbatis.kit.Ret;
import cn.sylinx.hbatis.plugin.transaction.TransactionIsolationWrapper;

/**
 * 事务处理
 * 
 * @author han
 *
 */
public interface ITransaction {

	/**
	 * 事务执行
	 * 
	 * @return boolean
	 * @throws SQLException
	 *             sql异常
	 */
	Ret run() throws SQLException;

	/**
	 * 事务类型
	 * 
	 * @return
	 */
	default Integer transactionIsolation() {
		return TransactionIsolationWrapper.ME.getTransactionIsolation();
	}
}
