package cn.sylinx.hbatis.db.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FluentSqlParams<T> {

	private Class<T> modelClass;
	private String selectColumns;
	private boolean distinct;
	private boolean count;
	private String tableName;
	private StringBuilder conditionSQL;
	private Map<String, Object> updateColumns;
	private List<String> excludedColumns;
	private String orderBy;
	private String limitSQL;
	private List<Object> paramValues = new ArrayList<>(8);
	private String[] primaryKeyColumn;
	private T model;
	private Map<String, String> attrs;
	private String preEscape;
	private String postEscape;
	private boolean singleField = false;

	public String getLimitSQL() {
		return limitSQL;
	}

	public void setLimitSQL(String limitSQL) {
		this.limitSQL = limitSQL;
	}

	public String mapColumn(String column) {
		String trueColumn = attrs.get(column);
		return preEscape + (trueColumn == null ? column : trueColumn) + postEscape;
	}

	public String getPreEscape() {
		return preEscape;
	}

	public void setPreEscape(String preEscape) {
		this.preEscape = preEscape;
	}

	public String getPostEscape() {
		return postEscape;
	}

	public void setPostEscape(String postEscape) {
		this.postEscape = postEscape;
	}

	public Map<String, String> getAttrs() {
		return attrs;
	}

	public void setAttrs(Map<String, String> attrs) {
		this.attrs = attrs;
	}

	public Class<T> getModelClass() {
		return modelClass;
	}

	public void setModelClass(Class<T> modelClass) {
		this.modelClass = modelClass;
	}

	public String getSelectColumns() {
		return selectColumns;
	}

	public void setSelectColumns(String selectColumns) {
		this.selectColumns = selectColumns;
	}

	public boolean isDistinct() {
		return distinct;
	}

	public void setDistinct(boolean distinct) {
		this.distinct = distinct;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public StringBuilder getConditionSQL() {
		return conditionSQL;
	}

	public void setConditionSQL(StringBuilder conditionSQL) {
		this.conditionSQL = conditionSQL;
	}

	public Map<String, Object> getUpdateColumns() {
		return updateColumns;
	}

	public void setUpdateColumns(Map<String, Object> updateColumns) {
		this.updateColumns = updateColumns;
	}

	public List<String> getExcludedColumns() {
		return excludedColumns;
	}

	public void setExcludedColumns(List<String> excludedColumns) {
		this.excludedColumns = excludedColumns;
	}

	public String getOrderBy() {
		return orderBy;
	}

	public void setOrderBy(String orderBy) {
		this.orderBy = orderBy;
	}

	public List<Object> getParamValues() {
		return paramValues;
	}

	public void setParamValues(List<Object> paramValues) {
		this.paramValues = paramValues;
	}

	public String[] getPrimaryKeyColumn() {
		return primaryKeyColumn;
	}

	public void setPrimaryKeyColumn(String[] primaryKeyColumn) {
		this.primaryKeyColumn = primaryKeyColumn;
	}

	public T getModel() {
		return model;
	}

	public void setModel(T model) {
		this.model = model;
	}

	public boolean isCount() {
		return count;
	}

	public void setCount(boolean count) {
		this.count = count;
	}

	public boolean isSingleField() {
		return singleField;
	}

	public void setSingleField(boolean singleField) {
		this.singleField = singleField;
	}

}
