package cn.sylinx.hbatis.db.common;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;

import cn.sylinx.hbatis.db.cache.CacheKeyGenerator;
import cn.sylinx.hbatis.db.cache.CacheQuery;
import cn.sylinx.hbatis.db.cache.ICacheKit;
import cn.sylinx.hbatis.db.cache.IDataLoader;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;

/**
 * 缓存查询实现类
 * 
 * @author han
 *
 */
public class DefaultCacheQuery implements CacheQuery {

	/**
	 * DbPro对象
	 */
	private final DbPro dbPro;
	private ICacheKit cacheKit;

	public DefaultCacheQuery(DbPro dbPro) {
		this.dbPro = dbPro;
		this.cacheKit = ICacheKit.create();
	}

	public String getSqlMD5(String key) {
		if (StrKit.isEmpty(key)) {
			return "";
		}

		MessageDigest digest = null;
		byte buffer[] = key.getBytes(Charset.defaultCharset());

		try {
			digest = MessageDigest.getInstance("MD5");
			digest.update(buffer);
		} catch (Exception e) {
			GLog.error("md5 encode error", e);
		}

		BigInteger bigInt = new BigInteger(1, digest.digest());
		return bigInt.toString(16);
	}

	@Override
	public Record queryFirstRecord(final String sql, final Object... params) {

		if (!cacheKit.isInited()) {
			throw new RuntimeException("缓存没有配置");
		}

		Object key = CacheKeyGenerator.generateCacheKey(dbPro.getDataSourceName() + "Q1", sql, params);

		String cacheKey = getSqlMD5(String.valueOf(key));

		return cacheKit.get(ICacheKit.DEFAULT_CACHENAME, cacheKey, new IDataLoader<Record>() {
			@Override
			public Record load() {
				return dbPro.queryFirstRecord(sql, params);
			}
		});
	}

	@Override
	public List<Record> queryRecords(final String sql, final Object... params) {

		if (!cacheKit.isInited()) {
			throw new RuntimeException("缓存没有配置");
		}

		Object key = CacheKeyGenerator.generateCacheKey(dbPro.getDataSourceName() + "Q2", sql, params);

		String cacheKey = getSqlMD5(String.valueOf(key));

		return cacheKit.get(ICacheKit.DEFAULT_CACHENAME, cacheKey, new IDataLoader<List<Record>>() {
			@Override
			public List<Record> load() {
				return dbPro.queryRecords(sql, params);
			}
		});
	}

	@Override
	public List<Object[]> query(final String sql, final Object... params) {

		if (!cacheKit.isInited()) {
			throw new RuntimeException("缓存没有配置");
		}

		Object key = CacheKeyGenerator.generateCacheKey(dbPro.getDataSourceName() + "Q3", sql, params);

		String cacheKey = getSqlMD5(String.valueOf(key));

		return cacheKit.get(ICacheKit.DEFAULT_CACHENAME, cacheKey, new IDataLoader<List<Object[]>>() {
			@Override
			public List<Object[]> load() {
				return dbPro.query(sql, params);
			}
		});
	}

	@Override
	public List<Map<String, Object>> queryMap(final String sql, final Object... params) {

		if (!cacheKit.isInited()) {
			throw new RuntimeException("缓存没有配置");
		}

		Object key = CacheKeyGenerator.generateCacheKey(dbPro.getDataSourceName() + "Q4", sql, params);

		String cacheKey = getSqlMD5(String.valueOf(key));

		return cacheKit.get(ICacheKit.DEFAULT_CACHENAME, cacheKey, new IDataLoader<List<Map<String, Object>>>() {
			@Override
			public List<Map<String, Object>> load() {
				return dbPro.queryMap(sql, params);
			}
		});
	}

	@Override
	public Object[] queryFirst(final String sql, final Object... params) {

		if (!cacheKit.isInited()) {
			throw new RuntimeException("缓存没有配置");
		}

		Object key = CacheKeyGenerator.generateCacheKey(dbPro.getDataSourceName() + "Q5", sql, params);

		String cacheKey = getSqlMD5(String.valueOf(key));

		return cacheKit.get(ICacheKit.DEFAULT_CACHENAME, cacheKey, new IDataLoader<Object[]>() {
			@Override
			public Object[] load() {
				return dbPro.queryFirst(sql, params);
			}
		});
	}

	@Override
	public Map<String, Object> queryFirstMap(final String sql, final Object... params) {

		if (!cacheKit.isInited()) {
			throw new RuntimeException("缓存没有配置");
		}

		Object key = CacheKeyGenerator.generateCacheKey(dbPro.getDataSourceName() + "Q6", sql, params);

		String cacheKey = getSqlMD5(String.valueOf(key));

		return cacheKit.get(ICacheKit.DEFAULT_CACHENAME, cacheKey, new IDataLoader<Map<String, Object>>() {
			@Override
			public Map<String, Object> load() {
				return dbPro.queryFirstMap(sql, params);
			}
		});
	}

	@Override
	public <T> List<T> query(final String sql, final QueryMapper<T> mapper, final Object... params) {

		if (!cacheKit.isInited()) {
			throw new RuntimeException("缓存没有配置");
		}

		Object key = CacheKeyGenerator.generateCacheKey(dbPro.getDataSourceName() + "Q7", sql, params);

		String cacheKey = getSqlMD5(String.valueOf(key));

		return cacheKit.get(ICacheKit.DEFAULT_CACHENAME, cacheKey, new IDataLoader<List<T>>() {
			@Override
			public List<T> load() {
				return dbPro.query(sql, mapper, params);
			}
		});
	}

	@Override
	public <T> T queryFirst(final String sql, final QueryMapper<T> mapper, final Object... params) {

		if (!cacheKit.isInited()) {
			throw new RuntimeException("缓存没有配置");
		}

		Object key = CacheKeyGenerator.generateCacheKey(dbPro.getDataSourceName() + "Q8", sql, params);

		String cacheKey = getSqlMD5(String.valueOf(key));

		return cacheKit.get(ICacheKit.DEFAULT_CACHENAME, cacheKey, new IDataLoader<T>() {
			@Override
			public T load() {
				return dbPro.queryFirst(sql, mapper, params);
			}
		});
	}

}
