package cn.sylinx.hbatis.db.common;

import java.util.List;
import java.util.Map;

/**
 * 数据查询对象
 * 
 * @author han
 *
 */
public interface DbQuery {

	/**
	 * 查询一条记录
	 * 
	 * @param sql
	 *            sql语句
	 * @param params
	 *            参数
	 * @return Record
	 */
	public Record queryFirstRecord(final String sql, final Object... params);

	/**
	 * 查询记录
	 * 
	 * @param sql
	 *            sql语句
	 * @param params
	 *            参数
	 * @return List<Record>
	 */
	public List<Record> queryRecords(final String sql, final Object... params);

	/**
	 * 查询
	 * 
	 * @param sql
	 *            sql语句
	 * @param params
	 *            参数
	 * @return List<Object[]>
	 */
	public List<Object[]> query(final String sql, final Object... params);

	/**
	 * 查询
	 * 
	 * @param sql
	 *            sql语句
	 * @param params
	 *            参数
	 * @return List<Map<String, Object>>
	 */
	public List<Map<String, Object>> queryMap(final String sql, final Object... params);

	/**
	 * 查询一条记录
	 * 
	 * @param sql
	 *            sql语句
	 * @param params
	 *            参数
	 * @return Object[]
	 */
	public Object[] queryFirst(final String sql, final Object... params);

	/**
	 * 查询一条记录
	 * 
	 * @param sql
	 *            sql语句
	 * @param params
	 *            参数
	 * @return Map<String, Object>
	 */
	public Map<String, Object> queryFirstMap(final String sql, final Object... params);

}
