package cn.sylinx.hbatis.db.common;

import java.io.Serializable;

/**
 * 简单的映射操作
 * 
 * @author han
 *
 */
public interface DbMapper extends MapperQuery, ObjectQuery {

	/**
	 * 更新
	 * 
	 * @param t
	 *            更新
	 * @return 更新记录数
	 */
	public <T> int update(T t);

	/**
	 * 保存
	 * 
	 * @param t
	 *            T对象
	 * @return 主键
	 */
	public <T> Serializable save(T t);

	/**
	 * 删除
	 * 
	 * @param t
	 *            T对象
	 * @return 删除数量
	 */
	public <T> int delete(T t);

}
