/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.tool;

import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.anno.BlobType;
import cn.sylinx.hbatis.db.mapper.anno.ColumnDesc;
import cn.sylinx.hbatis.db.mapper.anno.TextType;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.plugin.model.ModelFabric;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlserverRepositoryUtil {
    public static final String SQLSERVER_QUOTES_L = "[";
    public static final String SQLSERVER_QUOTES_R = "]";
    public static final String SQLSERVER_CREATE_TEMPLATE = "CREATE TABLE [dbo].[%s] (";
    public static final String SQLSERVER_ROW_PK = "CONSTRAINT [PK_%s] PRIMARY KEY CLUSTERED ([id]) ";
    public static final String SQLSERVER_TABLE_COMMENT = "EXEC sp_addextendedproperty 'MS_Description', N'%s', 'SCHEMA', 'dbo', 'TABLE', '%s';";
    public static final String SQLSERVER_COLUMN_COMMENT = "EXEC sp_addextendedproperty 'MS_Description', N'%s', 'SCHEMA', 'dbo', 'TABLE', '%s', 'COLUMN', '%s';";
    public static final String SQLSERVER_ALTER_TABLE = "ALTER TABLE [dbo].[%S] ";
    public static final String SQLSERVER_ALTER_TABLE_ADD_COL = "ADD";
    public static final String SQLSERVER_ALTER_TABLE_MODIFY_COL = "ALTER COLUMN";
    public static final String SQLSERVER_ALTER_COLUMN_COMMENT = "IF ((SELECT COUNT(*) FROM ::fn_listextendedproperty('MS_Description', 'SCHEMA', 'dbo', 'TABLE', '%s', 'COLUMN', '%s')) > 0) EXEC sp_updateextendedproperty 'MS_Description', N'%s', 'SCHEMA', 'dbo', 'TABLE', '%s', 'COLUMN', '%s' ELSE EXEC sp_addextendedproperty 'MS_Description', N'%s', 'SCHEMA', 'dbo', 'TABLE', '%s', 'COLUMN', '%s'";
    protected static final Map<String, String> SQLSERVER_JAVA_JDBC_MAP = new HashMap<String, String>();
    private Class<? extends Object> clz;
    private List<Field> fields;
    private String tableName;
    private String tableDesc;
    private Map<String, String> attrMapping;
    private Map<String, ColumnDesc> fieldDesc;
    private Map<String, Field> fieldMap;

    public SqlserverRepositoryUtil(Class<? extends Object> clz) {
        this.clz = clz;
        if (clz == null) {
            throw new RuntimeException("clz is null or path is null");
        }
        ModelFabric modelFabric = ModelBuilder.getModelFabric(this.clz);
        this.fields = modelFabric.getFields();
        this.tableName = modelFabric.getTableName();
        this.tableDesc = modelFabric.getTable().desc();
        this.attrMapping = modelFabric.getAttrMapping();
        this.fieldDesc = modelFabric.getFieldDesc();
        this.fieldMap = modelFabric.getFieldMap();
    }

    public String generateSql() {
        StringBuilder commentSb = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(SQLSERVER_CREATE_TEMPLATE, this.tableName)).append("\n");
        ArrayList<Field> sortField = new ArrayList<Field>();
        for (Field field : this.fields) {
            if (field.getName().equals("id")) {
                sortField.add(0, field);
                continue;
            }
            sortField.add(field);
        }
        for (Field field : sortField) {
            sb.append(this.generateSingleColumn(field, commentSb)).append("\n");
        }
        sb.append(String.format(SQLSERVER_ROW_PK, this.tableName)).append(");\n");
        if (StrKit.isNotBlank(this.tableDesc)) {
            sb.append(String.format(SQLSERVER_TABLE_COMMENT, this.tableDesc, this.tableName)).append("\n");
        }
        if (commentSb.length() > 0) {
            sb.append(commentSb.toString());
        }
        return sb.toString();
    }

    private String generateSingleColumn(Field field, StringBuilder commentSb) {
        StringBuilder sb = new StringBuilder();
        String propertyName = field.getName();
        ColumnDesc cd = this.fieldDesc.get(propertyName);
        String javaType = this.getFieldType(field);
        String jdbcType = this.toJdbcType(javaType);
        String columName = this.attrMapping.get(propertyName);
        if (StrKit.isBlank(columName)) {
            columName = propertyName;
        }
        String column_template = "[%s] %s,";
        int len = 0;
        int precision = 0;
        boolean blob = false;
        boolean text = false;
        BlobType bt = BlobType.MIN;
        TextType tt = TextType.MIN;
        String comment = null;
        boolean nullable = true;
        if (cd != null) {
            len = cd.len();
            precision = cd.precision();
            comment = cd.desc();
            nullable = cd.nullable();
            blob = cd.blob();
            text = cd.text();
            bt = cd.blobType();
            tt = cd.textType();
        }
        if (blob) {
            String key = javaType + "." + bt.name();
            jdbcType = this.toJdbcType(key);
        } else if (text) {
            String key = javaType + "." + tt.name();
            jdbcType = this.toJdbcType(key);
        } else if (len > 0) {
            jdbcType = jdbcType + (precision == 0 ? "(" + len + ")" : "(" + len + "," + precision + ")");
        } else if ("varchar".equals(jdbcType)) {
            jdbcType = jdbcType + "(50)";
        }
        jdbcType = jdbcType + (nullable ? " NULL" : " NOT NULL");
        if ("id".equals(field.getName())) {
            jdbcType = "bigint IDENTITY(1,1) NOT NULL";
        }
        sb.append(String.format(column_template, columName, jdbcType));
        if (StrKit.isNotBlank(comment)) {
            commentSb.append(String.format(SQLSERVER_COLUMN_COMMENT, comment, this.tableName, columName)).append("\n");
        }
        return sb.toString();
    }

    protected String toJdbcType(String javaType) {
        return SQLSERVER_JAVA_JDBC_MAP.get(javaType);
    }

    protected String getFieldType(Field field) {
        return field.getType().getName();
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String generateModifyTableColumnDDL(String prop) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(SQLSERVER_ALTER_TABLE, this.tableName)).append(" ").append(SQLSERVER_ALTER_TABLE_MODIFY_COL).append(" ");
        String propertyName = prop;
        Field field = this.fieldMap.get(prop);
        ColumnDesc cd = this.fieldDesc.get(propertyName);
        String javaType = this.getFieldType(field);
        String jdbcType = this.toJdbcType(javaType);
        String columName = this.attrMapping.get(propertyName);
        if (StrKit.isBlank(columName)) {
            columName = propertyName;
        }
        String column_template = "[%s] %s;\n";
        int len = 0;
        int precision = 0;
        boolean blob = false;
        boolean text = false;
        BlobType bt = BlobType.MIN;
        TextType tt = TextType.MIN;
        String comment = null;
        boolean nullable = true;
        if (cd != null) {
            len = cd.len();
            precision = cd.precision();
            comment = cd.desc();
            nullable = cd.nullable();
            blob = cd.blob();
            text = cd.text();
            bt = cd.blobType();
            tt = cd.textType();
        }
        if (blob) {
            String key = javaType + "." + bt.name();
            jdbcType = this.toJdbcType(key);
        } else if (text) {
            String key = javaType + "." + tt.name();
            jdbcType = this.toJdbcType(key);
        } else if (len > 0) {
            jdbcType = jdbcType + (precision == 0 ? "(" + len + ")" : "(" + len + "," + precision + ")");
        } else if ("varchar".equals(jdbcType)) {
            jdbcType = jdbcType + "(50)";
        }
        jdbcType = jdbcType + (nullable ? " NULL" : " NOT NULL");
        if ("id".equals(field.getName())) {
            jdbcType = "bigint IDENTITY(1,1) NOT NULL";
        }
        sb.append(String.format(column_template, columName, jdbcType));
        if (StrKit.isNotBlank(comment)) {
            sb.append(this.createColumnCommentSql(columName, comment));
        }
        return sb.toString();
    }

    private String createColumnCommentSql(String column, String comment) {
        String cmt = String.format(SQLSERVER_ALTER_COLUMN_COMMENT, this.tableName, column, comment, this.tableName, column, comment, this.tableName, column);
        return cmt + ";\n";
    }

    public String generateAddTableColumnDDL(String prop) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(SQLSERVER_ALTER_TABLE, this.tableName)).append(" ").append(SQLSERVER_ALTER_TABLE_ADD_COL).append(" ");
        String propertyName = prop;
        Field field = this.fieldMap.get(prop);
        ColumnDesc cd = this.fieldDesc.get(propertyName);
        String javaType = this.getFieldType(field);
        String jdbcType = this.toJdbcType(javaType);
        String columName = this.attrMapping.get(propertyName);
        if (StrKit.isBlank(columName)) {
            columName = propertyName;
        }
        String column_template = "[%s] %s;\n";
        int len = 0;
        int precision = 0;
        boolean blob = false;
        boolean text = false;
        BlobType bt = BlobType.MIN;
        TextType tt = TextType.MIN;
        String comment = null;
        boolean nullable = true;
        if (cd != null) {
            len = cd.len();
            precision = cd.precision();
            comment = cd.desc();
            nullable = cd.nullable();
            blob = cd.blob();
            text = cd.text();
            bt = cd.blobType();
            tt = cd.textType();
        }
        if (blob) {
            String key = javaType + "." + bt.name();
            jdbcType = this.toJdbcType(key);
        } else if (text) {
            String key = javaType + "." + tt.name();
            jdbcType = this.toJdbcType(key);
        } else if (len > 0) {
            jdbcType = jdbcType + (precision == 0 ? "(" + len + ")" : "(" + len + "," + precision + ")");
        } else if ("varchar".equals(jdbcType)) {
            jdbcType = jdbcType + "(50)";
        }
        jdbcType = jdbcType + (nullable ? " NULL" : " NOT NULL");
        if ("id".equals(field.getName())) {
            jdbcType = "bigint IDENTITY(1,1) NOT NULL";
        }
        sb.append(String.format(column_template, columName, jdbcType));
        if (StrKit.isNotBlank(comment)) {
            sb.append(String.format(SQLSERVER_COLUMN_COMMENT, comment, this.tableName, columName)).append("\n");
        }
        return sb.toString();
    }

    static {
        SQLSERVER_JAVA_JDBC_MAP.put("java.util.Date", "datetime");
        SQLSERVER_JAVA_JDBC_MAP.put("java.lang.String", "varchar");
        SQLSERVER_JAVA_JDBC_MAP.put("java.lang.String.MIN", "text");
        SQLSERVER_JAVA_JDBC_MAP.put("java.lang.String.MEDIUM", "text");
        SQLSERVER_JAVA_JDBC_MAP.put("java.lang.String.LONG", "text");
        SQLSERVER_JAVA_JDBC_MAP.put("java.lang.Long", "bigint");
        SQLSERVER_JAVA_JDBC_MAP.put("java.lang.Byte", "tinyint");
        SQLSERVER_JAVA_JDBC_MAP.put("java.lang.Short", "smallint");
        SQLSERVER_JAVA_JDBC_MAP.put("java.math.BigInteger", "bigint");
        SQLSERVER_JAVA_JDBC_MAP.put("java.math.BigDecimal", "decimal");
        SQLSERVER_JAVA_JDBC_MAP.put("java.lang.Integer", "int");
        SQLSERVER_JAVA_JDBC_MAP.put("java.lang.Float", "decimal(12,4)");
        SQLSERVER_JAVA_JDBC_MAP.put("java.lang.Double", "decimal(16,5)");
        SQLSERVER_JAVA_JDBC_MAP.put("java.lang.Boolean", "bit");
        SQLSERVER_JAVA_JDBC_MAP.put("[B", "binary");
        SQLSERVER_JAVA_JDBC_MAP.put("[B.MIN", "binary");
        SQLSERVER_JAVA_JDBC_MAP.put("[B.MEDIUM", "binary");
        SQLSERVER_JAVA_JDBC_MAP.put("[B.LONG", "binary");
    }
}

