/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.plugin.ehcache;

import cn.sylinx.hbatis.db.cache.ICacheKit;
import cn.sylinx.hbatis.db.cache.IDataLoader;
import cn.sylinx.hbatis.log.GLog;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public enum CacheKit implements ICacheKit
{
    INSTANCE;

    private CacheManager cacheManager;
    private AtomicBoolean inited = new AtomicBoolean(false);

    @Override
    public boolean isInited() {
        return this.inited.get();
    }

    public ICacheKit init(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.inited.set(true);
        return this;
    }

    public void destory() {
        this.cacheManager = null;
        this.inited.set(false);
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getOrAddCache(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            CacheManager cacheManager = this.cacheManager;
            synchronized (cacheManager) {
                cache = this.cacheManager.getCache(cacheName);
                if (cache == null) {
                    GLog.info("Could not find cache config [" + cacheName + "], using default.", new Object[0]);
                    this.cacheManager.addCacheIfAbsent(cacheName);
                    cache = this.cacheManager.getCache(cacheName);
                    GLog.debug("Cache [" + cacheName + "] started.", new Object[0]);
                }
            }
        }
        return cache;
    }

    public void put(String cacheName, Object key, Object value) {
        this.getOrAddCache(cacheName).put(new Element(key, value));
    }

    public <T> T get(String cacheName, Object key) {
        Element element = this.getOrAddCache(cacheName).get(key);
        return (T)(element != null ? element.getObjectValue() : null);
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader<?> dataLoader) {
        T data = this.get(cacheName, key);
        if (data == null) {
            data = this.loadAndGet(cacheName, key, dataLoader);
        }
        return data;
    }

    private synchronized <T> T loadAndGet(String cacheName, Object key, IDataLoader<?> dataLoader) {
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            this.put(cacheName, key, data);
        }
        return data;
    }
}

