/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.dialect.sql;

import cn.sylinx.hbatis.db.dialect.sql.SqlBuilder;
import cn.sylinx.hbatis.db.mapper.DeleteMapper;
import cn.sylinx.hbatis.db.mapper.InsertMapper;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.UpdateMapper;
import cn.sylinx.hbatis.exception.ExecutingException;
import cn.sylinx.hbatis.ext.model.Model;
import cn.sylinx.hbatis.kit.Pair;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.kit.Tuple;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.model.ModelFabric;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultSqlBuilder
implements SqlBuilder {
    private String escape0 = "";
    private String escape1 = "";

    public DefaultSqlBuilder() {
        String[] escapes = this.getEscapeChar();
        if (escapes != null && escapes.length >= 2) {
            this.escape0 = escapes[0];
            this.escape1 = escapes[1];
        }
    }

    protected String[] getEscapeChar() {
        return new String[]{"", ""};
    }

    @Override
    public Tuple buildPaginatorSql(String preSql, int pageNumber, int pageSize) {
        String sqlCount = "select count(1) as totalCount from (" + preSql + ") as temp";
        String sql = preSql + " limit ?, ? ";
        int offset = pageSize * (pageNumber - 1);
        Object[] params = new Object[]{offset, pageSize};
        return Tuple.apply(sqlCount, sql, params);
    }

    @Override
    public <T> Tuple buildDeleteSQL(T t) {
        DeleteMapper<T> mapper = ModelBuilder.buildDeleteMapper(t);
        if (mapper == null) {
            return null;
        }
        String tableName = mapper.getTableName();
        List<String> pks = mapper.getPrimaryKeyFieldNameList();
        Map<String, String> map = mapper.getJavaToJdbcMapper();
        if (StrKit.isBlank(tableName)) {
            GLog.error("table name is empty~", new Object[0]);
            return null;
        }
        if (pks == null || pks.isEmpty()) {
            GLog.error("primary key is empty~", new Object[0]);
            return null;
        }
        if (map == null || map.isEmpty()) {
            GLog.error("java to jdbc mapper is empty~", new Object[0]);
            return null;
        }
        String token = " and ";
        List<Field> fields = ModelBuilder.getObjectAllFieldsWithcache(t.getClass());
        StringBuilder sql = new StringBuilder("delete from " + this.escape0 + tableName + this.escape1 + " where ");
        boolean find = false;
        ArrayList<Object> params = new ArrayList<Object>();
        try {
            for (Field item : fields) {
                String fieldName = item.getName();
                if (!pks.contains(fieldName)) continue;
                String f = map.get(fieldName);
                item.setAccessible(true);
                Object v = item.get(t);
                if (f == null || v == null) continue;
                find = true;
                sql.append(this.escape0).append(f).append(this.escape1).append(" = ? ").append(" and ");
                params.add(v);
            }
        }
        catch (IllegalAccessException e) {
            throw new ExecutingException(e);
        }
        if (!find) {
            return null;
        }
        int totalLen = sql.length();
        int index = sql.length() - " and ".length();
        sql.delete(index, totalLen);
        Object[] objects = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            objects[i] = params.get(i);
        }
        String sqlNative = sql.toString();
        GLog.debug("sql:{} , params:{}", sqlNative, objects);
        return Tuple.apply(sqlNative, objects);
    }

    @Override
    public <T> Tuple buildInsertSQL(T t) {
        InsertMapper<T> mapper = ModelBuilder.buildInsertMapper(t);
        if (mapper == null) {
            return null;
        }
        Map<String, String> map = mapper.getJavaToJdbcMapper();
        String tableName = mapper.getTableName();
        if (map == null || map.isEmpty()) {
            GLog.error("insert mapper is empty~", new Object[0]);
            return null;
        }
        if (StrKit.isBlank(tableName)) {
            GLog.error("table name is empty~", new Object[0]);
            return null;
        }
        List<Field> fields = ModelBuilder.getObjectAllFieldsWithcache(t.getClass());
        if (fields.isEmpty()) {
            return null;
        }
        StringBuilder fds = new StringBuilder();
        StringBuilder fdsv = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        fds.append("(");
        fdsv.append("(");
        try {
            for (Field item : fields) {
                String fieldName = item.getName();
                if (!map.containsKey(fieldName)) continue;
                item.setAccessible(true);
                Object v = item.get(t);
                if (v == null) continue;
                String jdbcFieldName = map.get(fieldName);
                fds.append(this.escape0).append(jdbcFieldName).append(this.escape1).append(",");
                fdsv.append("?,");
                params.add(v);
            }
        }
        catch (IllegalAccessException e) {
            throw new ExecutingException(e);
        }
        if (fds.length() <= 1) {
            return null;
        }
        fds.deleteCharAt(fds.length() - 1);
        fdsv.deleteCharAt(fdsv.length() - 1);
        fds.append(")");
        fdsv.append(")");
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(this.escape0).append(tableName).append(this.escape1).append((CharSequence)fds).append(" values ").append((CharSequence)fdsv);
        Object[] objects = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            objects[i] = params.get(i);
        }
        String sql = sb.toString();
        GLog.debug("sql:{} , params:{}", sql, objects);
        return Tuple.apply(sql, objects);
    }

    @Override
    public <T> Tuple buildUpdateSQL(T t) {
        List<Field> fields;
        UpdateMapper<T> mapper = ModelBuilder.buildUpdateMapper(t);
        if (mapper == null) {
            return null;
        }
        Map<String, String> map = mapper.getJavaToJdbcMapper();
        List<String> pks = mapper.getPrimaryKeyFieldNameList();
        String tableName = mapper.getTableName();
        if (map == null || map.isEmpty()) {
            GLog.error("update mapper is empty~", new Object[0]);
            return null;
        }
        if (StrKit.isBlank(tableName)) {
            GLog.error("table name is empty~", new Object[0]);
            return null;
        }
        if (pks == null) {
            pks = Collections.emptyList();
        }
        if ((fields = ModelBuilder.getObjectAllFieldsWithcache(t.getClass())).isEmpty()) {
            return null;
        }
        HashMap<String, Object> pkKv = new HashMap<String, Object>();
        StringBuilder fds = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        Set<Object> nullableSets = new HashSet();
        if (t instanceof Model) {
            nullableSets = ((Model)t).getNullableFields();
        }
        try {
            for (Field item : fields) {
                item.setAccessible(true);
                Iterator fieldName = item.getName();
                if (pks.contains(fieldName)) {
                    Object pkValue = item.get(t);
                    String columnKey = map.get(fieldName);
                    pkKv.put(columnKey, pkValue);
                    continue;
                }
                String f = map.get(fieldName);
                Object v = item.get(t);
                if (f == null) continue;
                boolean nullable = nullableSets.contains(fieldName);
                if (v != null) {
                    fds.append(this.escape0).append(f).append(this.escape1).append(" = ?,");
                    params.add(v);
                    continue;
                }
                if (!nullable) continue;
                fds.append(this.escape0).append(f).append(this.escape1).append(" = NULL,");
            }
        }
        catch (IllegalAccessException e) {
            throw new ExecutingException(e);
        }
        if (fds.length() <= 0) {
            throw new RuntimeException("update values is empty ~");
        }
        fds.deleteCharAt(fds.length() - 1);
        StringBuilder sb = new StringBuilder();
        sb.append("update ").append(this.escape0).append(tableName).append(this.escape1).append(" set ").append((CharSequence)fds);
        if (!pkKv.isEmpty()) {
            String token = " and ";
            sb.append(" where ");
            if (pks.size() == pkKv.size()) {
                for (String k : pks) {
                    String c = map.get(k);
                    sb.append(this.escape0).append(c).append(this.escape1).append(" = ?").append(" and ");
                    params.add(pkKv.get(c));
                }
            } else {
                for (Map.Entry entry : pkKv.entrySet()) {
                    sb.append(this.escape0).append((String)entry.getKey()).append(this.escape1).append(" = ?").append(" and ");
                    params.add(entry.getValue());
                }
            }
            int totalLen = sb.length();
            int index = sb.length() - " and ".length();
            sb.delete(index, totalLen);
        }
        Object[] objects = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            objects[i] = params.get(i);
        }
        String sql = sb.toString();
        GLog.debug("sql:{} , params:{}", sql, objects);
        return Tuple.apply(sql, objects);
    }

    @Override
    public Tuple buildDeleteByFieldSQL(List<Pair> kvList, Class<?> clz) {
        ModelFabric mf = ModelBuilder.getModelFabric(clz);
        String table = mf.getTableName();
        if (table == null) {
            throw new ExecutingException("\u5bf9\u8c61\u6ca1\u6709Table\u6ce8\u89e3");
        }
        Map<String, String> am = mf.getAttrMapping();
        if (am == null) {
            throw new ExecutingException("\u5bf9\u8c61\u6620\u5c04\u5b57\u6bb5\u7f3a\u5931");
        }
        String andToken = " and ";
        StringBuilder sb = new StringBuilder();
        ArrayList paramList = new ArrayList();
        for (int i = 0; i < kvList.size(); ++i) {
            Pair kv = kvList.get(i);
            String field = (String)kv.getKey();
            Object value = kv.getValue();
            String trueField = am.get(field);
            if (trueField == null) {
                trueField = field;
            }
            if (value == null) {
                sb.append(this.escape0).append(trueField).append(this.escape1).append(" is null").append(andToken);
                continue;
            }
            sb.append(this.escape0).append(trueField).append(this.escape1).append(" = ?").append(andToken);
            paramList.add(value);
        }
        sb.delete(sb.length() - andToken.length(), sb.length());
        String sql = "delete from " + this.escape0 + table + this.escape1 + " where " + sb.toString();
        return Tuple.apply(sql, paramList.toArray());
    }

    @Override
    public Tuple buildQueryByFieldSQL(List<Pair> kvList, Class<?> clz) {
        return this.buildQueryByFieldSQL(kvList, clz, null);
    }

    @Override
    public Tuple buildQueryByFieldSQL(List<Pair> kvList, Class<?> clz, String[] fields) {
        ModelFabric mf = ModelBuilder.getModelFabric(clz);
        String table = mf.getTableName();
        if (table == null) {
            throw new ExecutingException("\u5bf9\u8c61\u6ca1\u6709Table\u6ce8\u89e3");
        }
        Map<String, String> am = mf.getAttrMapping();
        if (am == null) {
            throw new ExecutingException("\u5bf9\u8c61\u6620\u5c04\u5b57\u6bb5\u7f3a\u5931");
        }
        String andToken = " and ";
        StringBuilder sb = new StringBuilder();
        ArrayList paramList = new ArrayList();
        for (int i = 0; i < kvList.size(); ++i) {
            String[] kv = kvList.get(i);
            String field = (String)kv.getKey();
            Object value = kv.getValue();
            String trueField = am.get(field);
            if (trueField == null) {
                trueField = field;
            }
            if (value == null) {
                sb.append(this.escape0).append(trueField).append(this.escape1).append(" is null").append(andToken);
                continue;
            }
            sb.append(this.escape0).append(trueField).append(this.escape1).append(" = ?").append(andToken);
            paramList.add(value);
        }
        sb.delete(sb.length() - andToken.length(), sb.length());
        StringBuilder sf = new StringBuilder();
        if (fields != null && fields.length > 0) {
            for (String field : fields) {
                String trueField = am.get(field);
                if (trueField == null) {
                    trueField = field;
                }
                sf.append(this.escape0).append(trueField).append(this.escape1).append(",");
            }
            sf.deleteCharAt(sf.length() - 1);
        } else {
            sf.append("*");
        }
        String sql = "select " + sf.toString() + " from " + this.escape0 + table + this.escape1 + " where " + sb.toString();
        return Tuple.apply(sql, paramList.toArray());
    }

    @Override
    public String buildSimpleQuery(Class<?> clz) {
        return this.buildSimpleQuery(clz, null);
    }

    @Override
    public String buildSimpleQuery(Class<?> clz, String[] fields) {
        ModelFabric mf = ModelBuilder.getModelFabric(clz);
        String table = mf.getTableName();
        if (table == null) {
            throw new RuntimeException("\u5bf9\u8c61\u6ca1\u6709Table\u6ce8\u89e3");
        }
        Map<String, String> am = mf.getAttrMapping();
        if (fields == null || fields.length == 0 || am == null) {
            return "select * from " + this.escape0 + table + this.escape1;
        }
        StringBuilder sb = new StringBuilder("select ");
        for (String field : fields) {
            String trueField = am.get(field);
            if (trueField == null) {
                trueField = field;
            }
            sb.append(this.escape0).append(trueField).append(this.escape1).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" from ").append(this.escape0).append(table).append(this.escape1);
        return sb.toString();
    }

    @Override
    public String buildValidateQuery() {
        return "SELECT 1";
    }

    @Override
    public String getTable(Class<?> clz) {
        return ModelBuilder.getModelTable(clz);
    }

    @Override
    public String getTableColumn(Class<?> clz, String prop) {
        ModelFabric mf = ModelBuilder.getModelFabric(clz);
        Map<String, String> attrMap = mf.getAttrMapping();
        String column = attrMap.get(prop);
        if (column == null) {
            column = prop;
        }
        return column;
    }

    @Override
    public String[] buildCreateTableDDL(Class<?> clz) {
        throw new UnsupportedOperationException("not implement");
    }

    @Override
    public String[] buildModifyTableColumnDDL(Class<?> clz, String prop) {
        throw new UnsupportedOperationException("not implement");
    }

    @Override
    public String[] buildAddTableColumnDDL(Class<?> clz, String prop) {
        throw new UnsupportedOperationException("not implement");
    }
}

