package cn.sylinx.hbatis.plugin.proxy;

import java.util.ArrayList;
import java.util.List;

import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.IPlugin;

/**
 * 第三方代理插件
 * 
 * @author han
 *
 */
public class ProxyPlugin implements IPlugin {

	private List<IPlugin> pluginList = new ArrayList<>();

	/**
	 * 添加第三方插件
	 * 
	 * @param plugin
	 */
	public void addPlugin(IPlugin plugin) {
		pluginList.add(plugin);
	}

	@Override
	public boolean start(Object... objects) {

		int count = 0;
		for (IPlugin plugin : pluginList) {

			if (plugin == null) {
				continue;
			}

			boolean bl = plugin.start();
			if (!bl) {
				// 初始化失败
				GLog.error("第三方插件初始化失败, plugin:{}", plugin.getClass());
			} else {
				GLog.info("第三方插件:{} 初始化成", plugin.getClass());
				count++;
			}

		}

		GLog.info("第三方插件启动完成，总数：{}, 成功个数：{}", pluginList.size(), count);
		return true;
	}

	@Override
	public boolean stop() {

		for (IPlugin plugin : pluginList) {

			if (plugin == null) {
				continue;
			}

			boolean bl = plugin.stop();
			if (!bl) {
				// 初始化失败
				GLog.error("第三方插件停止失败, plugin:{}", plugin.getClass());
			}
		}

		pluginList.clear();

		return true;
	}

}
