package cn.sylinx.hbatis.plugin.datasource;

import cn.sylinx.hbatis.ds.JdbcResourceManager;
import cn.sylinx.hbatis.ds.JdbcResourceWrapper;
import cn.sylinx.hbatis.plugin.IPlugin;

public abstract class JdbcResourcePlugin implements IPlugin {

	public final static String DEFAULT_JDBC_RESOURCE_NAME = "_hbatis_default_jdbc_resource";

	private JdbcResourceWrapper jrw = null;

	@Override
	public boolean start(Object... objects) {

		jrw = createJdbcResourceWrapper(objects);
		if (jrw == null) {
			throw new RuntimeException("JdbcResourceWrapper is null");
		}

		// 添加JdbcResource
		JdbcResourceManager.get().addJdbcResource(jrw);

		return true;
	}

	@Override
	public boolean stop() {

		if (jrw != null) {
			JdbcResourceManager.get().removeJdbcResource(jrw.getResourceName());
		}

		return true;
	}

	public abstract JdbcResourceWrapper createJdbcResourceWrapper(Object... objects);

}
