
package cn.sylinx.hbatis.kit;

import java.net.URL;

/**
 * StrKit.
 */
public class StrKit {

	/**
	 * 首字母变小写
	 * 
	 * @param str
	 *            String object
	 * @return first charactor to lower case
	 */
	public static String firstCharToLowerCase(String str) {
		char firstChar = str.charAt(0);
		if (firstChar >= 'A' && firstChar <= 'Z') {
			char[] arr = str.toCharArray();
			arr[0] += ('a' - 'A');
			return new String(arr);
		}
		return str;
	}

	/**
	 * 首字母变大写
	 * 
	 * @param str
	 *            String object
	 * @return the String which first charactor to upper case
	 */
	public static String firstCharToUpperCase(String str) {
		char firstChar = str.charAt(0);
		if (firstChar >= 'a' && firstChar <= 'z') {
			char[] arr = str.toCharArray();
			arr[0] -= ('a' - 'A');
			return new String(arr);
		}
		return str;
	}

	/**
	 * 字符串为 null 或者为 "" 时返回 true
	 * 
	 * @param str
	 *            String object
	 * @return true or false
	 */
	public static boolean isBlank(String str) {
		return str == null || "".equals(str.trim()) ? true : false;
	}

	/**
	 * 是否空
	 * 
	 * @param str
	 * @return
	 */
	public static boolean isEmpty(String str) {
		return ((str == null) || (str.length() == 0));
	}

	/**
	 * 字符串不为 null 而且不为 "" 时返回 true
	 * 
	 * @param str
	 *            String object
	 * @return true or false
	 */
	public static boolean isNotBlank(String str) {

		int length;

		if ((str == null) || ((length = str.length()) == 0)) {
			return false;
		}

		for (int i = 0; i < length; i++) {
			if (!Character.isWhitespace(str.charAt(i))) {
				return true;
			}
		}

		return false;
	}

	/**
	 * if the object array contain null object
	 * 
	 * @param paras
	 *            Object array
	 * @return true or false
	 */
	public static boolean containNull(Object... paras) {
		if (paras == null)
			return false;

		for (Object obj : paras)
			if (obj == null)
				return true;

		return false;
	}

	/**
	 * get the url as string
	 * 
	 * @param url
	 *            the URL
	 * @return the url as string
	 */
	public static String getRootPath(URL url) {

		String fileUrl = url.getFile();

		int pos = fileUrl.indexOf("!");

		if (-1 == pos) {
			return fileUrl;
		}

		return fileUrl.substring(5, pos);
	}

	// 首字母转小写
	public static String toLowerCaseFirstOne(String s) {
		if (Character.isLowerCase(s.charAt(0)))
			return s;
		else
			return (new StringBuilder()).append(Character.toLowerCase(s.charAt(0))).append(s.substring(1)).toString();
	}

	// 首字母转大写
	public static String toUpperCaseFirstOne(String s) {
		if (Character.isUpperCase(s.charAt(0)))
			return s;
		else
			return (new StringBuilder()).append(Character.toUpperCase(s.charAt(0))).append(s.substring(1)).toString();
	}

	// 大写字母前面加上下划线并转为全小写
	public static String enCodeUnderlined(String s) {
		char[] chars = toLowerCaseFirstOne(s).toCharArray();
		StringBuilder temp = new StringBuilder();
		for (int i = 0; i < chars.length; i++) {
			if (Character.isUpperCase(chars[i])) {
				temp.append("_");
			}
			temp.append(Character.toLowerCase(chars[i]));
		}
		return temp.toString();
	}

	// 删除下划线并转把后一个字母转成大写
	public static String deCodeUnderlined(String str) {

		String[] splitArr = str.split("_");
		StringBuilder sb = new StringBuilder();

		for (int i = 0; i < splitArr.length; i++) {
			if (i == 0) {
				sb.append(splitArr[0].toLowerCase());
				continue;
			}

			sb.append(toUpperCaseFirstOne(splitArr[i].toLowerCase()));
		}

		return sb.toString();
	}

}
