package cn.sylinx.hbatis.ext.xmapper.spi;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;

import cn.sylinx.hbatis.ext.xmapper.XmapperService;

public class XmapperServiceManager {

	private static XmapperService xmapperService;

	private static ReentrantLock lock = new ReentrantLock();

	public static XmapperService getXmapperService() {

		if (xmapperService != null) {
			return xmapperService;
		}

		// 加載MirageService
		loadXmapperService();

		return xmapperService;

	}

	private static void loadXmapperService() {

		try {

			lock.lock();

			if (xmapperService == null) {

				ServiceLoader<XmapperService> sl = ServiceLoader.load(XmapperService.class);
				Iterator<XmapperService> it = sl.iterator();
				xmapperService = it.hasNext() ? it.next() : null;
			}

		} finally {
			lock.unlock();
		}

	}

}
