package cn.sylinx.hbatis.ext.starter.pool;

import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

public class DefaultDataSourceSelector implements DataSourceSelector {

	private Map<String, Object> dsMap;
	private Map<String, Object> extConfig;

	public DefaultDataSourceSelector(Map<String, Object> dsMap, Map<String, Object> extConfig) {
		this.dsMap = new HashMap<>();
		this.dsMap.putAll(dsMap);
		this.extConfig = extConfig;
		combined();
	}

	private void combined() {
		this.dsMap.put("config", this.extConfig);
	}

	@Override
	public DataSource select(PoolType pt) {
		if (pt == null) {
			return null;
		}

		switch (pt) {
		case Druid:
			return new DruidDataSourceCreator().create(dsMap);

		case TomcatJdbc:
			return new TomcatJdbcDataSourceCreator().create(dsMap);

		case BoneCP:
			return new BoneCPDataSourceCreator().create(dsMap);

		case C3P0:
			return new C3p0DataSourceCreator().create(dsMap);

		case Dbcp2:
			return new Dbcp2DataSourceCreator().create(dsMap);

		case Dbcp:
			return new DbcpDataSourceCreator().create(dsMap);
			
		case Hikari:
			return new HikariDataSourceCreator().create(dsMap);

		default:
			break;
		}
		return null;
	}

}
