package cn.sylinx.hbatis.ext.parse;

import java.util.Map;

import cn.sylinx.hbatis.kit.StrKit;
import ognl.Ognl;
import ognl.OgnlException;

/**
 * sql 占位符解析处理器
 * 
 * @author han
 *
 */
public class SqlTokenHandler implements TokenHandler {

	private Map<String, Object> params;

	public SqlTokenHandler(Map<String, Object> params) {
		this.params = params;
	}

	@Override
	public Object hand(String content) {

		return StrKit.isNotBlank(content) ? (params == null ? null : params.get(content)) : null;
	}

	@Override
	public boolean condition(String condition) {

		try {
			Object ret = Ognl.getValue(condition, params);
			if (ret instanceof Boolean) {
				return (Boolean) ret;
			}
		} catch (OgnlException e) {
			return false;
		}

		return false;
	}

}
