package cn.sylinx.hbatis.ext.mirage;

import java.util.List;
import java.util.Map;

import cn.sylinx.hbatis.db.cache.CacheQuery;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.ext.parse.SqlParser;
import cn.sylinx.hbatis.ext.res.ClasspathSqlResource;
import cn.sylinx.hbatis.kit.Tuple;

public class DefaultMirageCacheQuery implements MirageCacheQuery {

	private CacheQuery cacheQuery;

	public DefaultMirageCacheQuery(CacheQuery cacheQuery) {
		this.cacheQuery = cacheQuery;
	}

	@Override
	public List<Map<String, Object>> queryForMapList(ClasspathSqlResource sqlResource, Map<String, Object> params) {

		Tuple tp = SqlParser.parseSql(sqlResource, params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);
		return cacheQuery.queryMap(st, pms);
	}

	@Override
	public List<Record> queryForRecords(ClasspathSqlResource sqlResource, Map<String, Object> params) {
		Tuple tp = SqlParser.parseSql(sqlResource, params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		return cacheQuery.queryRecords(st, pms);
	}

	@Override
	public Record queryFirstRecord(ClasspathSqlResource sqlResource, Map<String, Object> params) {

		Tuple tp = SqlParser.parseSql(sqlResource, params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		return cacheQuery.queryFirstRecord(st, pms);
	}

	@Override
	public List<Object[]> queryObjectArrayList(ClasspathSqlResource sqlResource, Map<String, Object> params) {

		Tuple tp = SqlParser.parseSql(sqlResource, params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		return cacheQuery.query(st, pms);
	}

	@Override
	public Object[] queryFirstObjectArray(ClasspathSqlResource sqlResource, Map<String, Object> params) {

		Tuple tp = SqlParser.parseSql(sqlResource, params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		return cacheQuery.queryFirst(st, pms);
	}

	@Override
	public Map<String, Object> queryFirstForMap(ClasspathSqlResource sqlResource, Map<String, Object> params) {

		Tuple tp = SqlParser.parseSql(sqlResource, params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);

		return cacheQuery.queryFirstMap(st, pms);
	}

	@Override
	public <T> List<T> query(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> clz) {

		Tuple tp = SqlParser.parseSql(sqlResource, params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);
		QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
		return cacheQuery.query(st, mapper, pms);
	}

	@Override
	public <T> T queryFirst(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> clz) {

		Tuple tp = SqlParser.parseSql(sqlResource, params);
		String st = (String) tp.get(0);
		Object[] pms = (Object[]) tp.get(1);
		QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
		return cacheQuery.queryFirst(st, mapper, pms);
	}

}
