package cn.sylinx.hbatis.ext.common.repository;

import java.io.Serializable;
import java.util.List;

import cn.sylinx.hbatis.db.common.FS;
import cn.sylinx.hbatis.db.common.Page;

/**
 * fluent sql support
 * @author han
 *
 */
public interface FluentSqlSupport {

	<T> List<T> query(FS<T> fluentSql);
	
	<T,R> List<R> queryObject(FS<T> fluentSql);
	
	<T> List<T> queryWithCache(FS<T> fluentSql);

	<T> T queryFirst(FS<T> fluentSql);
	
	<T,R> R queryFirstObject(FS<T> fluentSql);

	int update(FS<?> fluentSql);

	int delete(FS<?> fluentSql);
	
	int count(FS<?> fluentSql);

	Serializable insert(FS<?> fluentSql);

	<T> Page<T> queryPage(FS<T> fluentSql, int pageNumber, int pageSize);
}
