package cn.sylinx.hbatis.ds;

/**
 * 数据源封装类
 * 
 * @author han
 *
 */
public class JdbcResourceWrapper {

	/**
	 * 数据源名称
	 */
	private String resourceName;

	/**
	 * 数据源
	 */
	private JdbcResource jdbcResource;

	/**
	 * 是否默认数据源
	 */
	private boolean defaultResource;

	/**
	 * 获取数据源名称
	 * 
	 * @return String
	 */
	public String getResourceName() {
		return resourceName;
	}

	/**
	 * 设置数据源名称
	 * 
	 * @param resourceName
	 *            数据源名称
	 */
	public void setResourceName(String resourceName) {
		this.resourceName = resourceName;
	}

	/**
	 * 获取数据源
	 * 
	 * @return JdbcResource对象
	 */
	public JdbcResource getJdbcResource() {
		return jdbcResource;
	}

	/**
	 * 设置数据源
	 * 
	 * @param jdbcResource
	 *            数据源
	 */
	public void setJdbcResource(JdbcResource jdbcResource) {
		this.jdbcResource = jdbcResource;
	}

	/**
	 * 是否默认数据源
	 * 
	 * @return
	 */
	public boolean isDefaultResource() {
		return defaultResource;
	}

	/**
	 * 设置默认数据源
	 * 
	 * @param defaultResource
	 *            默认数据源
	 */
	public void setDefaultResource(boolean defaultResource) {
		this.defaultResource = defaultResource;
	}

	/**
	 * 释放资源
	 */
	public void clear() {
		resourceName = null;
		jdbcResource = null;
		defaultResource = false;
	}

}
