package cn.sylinx.hbatis.db.mapper.anno;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 列描述
 * 
 * @author han
 *
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
public @interface ColumnDesc {

	/**
	 * 字段描述
	 * 
	 * @return
	 */
	String desc() default "";

	/**
	 * 长度
	 * 
	 * @return
	 */
	int len() default 0;

	/**
	 * 精度
	 * 
	 * @return
	 */
	int precision() default 0;

	/**
	 * 是否可空
	 * 
	 * @return
	 */
	boolean nullable() default true;

	/**
	 * 二进制
	 * 
	 * @return
	 */
	boolean blob() default false;

	/**
	 * 二进制类型
	 * 
	 * @return
	 */
	BlobType blobType() default BlobType.MIN;

	/**
	 * 长文本
	 * 
	 * @return
	 */
	boolean text() default false;

	/**
	 * 长文本类型
	 * 
	 * @return
	 */
	TextType textType() default TextType.MIN;
}
