package cn.sylinx.hbatis.db.mapper.anno;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 属性和表列的映射关系
 * 
 * @author han
 *
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
public @interface AttributeColumnMapping {

	/**
	 * 列和属性的映射， 硬编码注解上。
	 * 
	 * @return String[]
	 */
	String[] value() default {};

	/**
	 * 列和属性的映射文件，写入映射文件。
	 * 
	 * @return
	 */
	String mappingFile() default "";

	/**
	 * 使用对象属性，即属性字段和数据库字段一致。
	 * 
	 * @return boolean
	 */
	boolean useAttribute() default true;

	/**
	 * 属性 列映射策略对应的类名称， 如果已配置，其它三项则失效。
	 * 
	 * @return
	 */
	String acmStrategy() default "";
}
